/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.util.display;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class ThreadSafeDecimalFormat
extends NumberFormat {
    final String pattern;
    final DecimalFormatSymbols symbols;
    private final ThreadLocal<DecimalFormat> threadLocal = new ThreadLocal<DecimalFormat>(){

        @Override
        protected DecimalFormat initialValue() {
            if (ThreadSafeDecimalFormat.this.symbols == null) {
                return new DecimalFormat(ThreadSafeDecimalFormat.this.pattern);
            }
            return new DecimalFormat(ThreadSafeDecimalFormat.this.pattern, ThreadSafeDecimalFormat.this.symbols);
        }
    };

    public ThreadSafeDecimalFormat(String pattern) {
        this(pattern, null);
    }

    public ThreadSafeDecimalFormat(String pattern, DecimalFormatSymbols symbols) {
        this.pattern = pattern;
        this.symbols = symbols;
    }

    @Override
    public StringBuffer format(double d, StringBuffer sb, FieldPosition p) {
        return this.threadLocal.get().format(d, sb, p);
    }

    @Override
    public StringBuffer format(long l, StringBuffer sb, FieldPosition p) {
        return this.threadLocal.get().format(l, sb, p);
    }

    @Override
    public Number parse(String s, ParsePosition p) {
        return this.threadLocal.get().parse(s, p);
    }
}

