/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.util.display;

import edu.iris.dmc.seedcodec.CodecException;
import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.sod.model.common.QuantityImpl;
import edu.sc.seis.sod.model.common.SamplingImpl;
import edu.sc.seis.sod.model.common.TimeRange;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.common.UnitRangeImpl;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.Plottable;
import edu.sc.seis.sod.model.seismogram.PlottableChunk;
import edu.sc.seis.sod.model.util.LinearInterp;
import edu.sc.seis.sod.util.display.IntRange;
import edu.sc.seis.sod.util.time.ClockUtil;
import java.awt.Dimension;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplePlotUtil {
    public static final Duration ONE_DAY = TimeUtils.ONE_DAY;
    private static final Logger logger = LoggerFactory.getLogger(SimplePlotUtil.class);

    public static Plottable makePlottable(LocalSeismogramImpl seis, int pixelsPerDay) throws CodecException {
        TimeRange correctedSeisRange = SimplePlotUtil.correctTimeRangeForPixelData(seis, pixelsPerDay);
        int startPoint = SimplePlotUtil.getPoint(seis, correctedSeisRange.getBeginTime());
        int endPoint = SimplePlotUtil.getPoint(seis, correctedSeisRange.getEndTime());
        IntRange seisPixelRange = SimplePlotUtil.getDayPixelRange(seis, pixelsPerDay, seis.getBeginTime());
        int numPixels = seisPixelRange.getDifference();
        Instant rangeEnd = correctedSeisRange.getBeginTime().plus(SimplePlotUtil.getPixelPeriod(pixelsPerDay).multipliedBy(numPixels));
        boolean corrected = false;
        if (rangeEnd.isAfter(correctedSeisRange.getEndTime())) {
            --numPixels;
            corrected = true;
        }
        int startPixel = seisPixelRange.getMin();
        int[][] pixels = new int[2][numPixels * 2];
        int pixelPoint = startPixel < 0 ? 0 : startPoint;
        Instant pixelEndTime = correctedSeisRange.getBeginTime();
        Duration pixelPeriod = SimplePlotUtil.getPixelPeriod(pixelsPerDay);
        if (corrected) {
            // empty if block
        }
        for (int i = 0; i < numPixels; ++i) {
            pixelEndTime = pixelEndTime.plus(pixelPeriod);
            int pos = 2 * i;
            int nextPos = pos + 1;
            pixels[0][pos] = startPixel + i;
            pixels[0][nextPos] = pixels[0][pos];
            int nextPixelPoint = SimplePlotUtil.getPixel(startPoint, endPoint, correctedSeisRange.getBeginTime(), correctedSeisRange.getEndTime(), pixelEndTime);
            QuantityImpl min = seis.getMinValue(pixelPoint, nextPixelPoint);
            pixels[1][pos] = (int)min.getValue();
            QuantityImpl max = seis.getMaxValue(pixelPoint, nextPixelPoint);
            pixels[1][nextPos] = (int)max.getValue();
            if (corrected && (i < 2 || i >= numPixels - 2)) {
                logger.debug(pixels[0][pos] + ": min " + min.getValue() + " max " + max.getValue());
            }
            pixelPoint = nextPixelPoint;
        }
        return new Plottable(pixels[0], pixels[1]);
    }

    public static Plottable getEmptyPlottable() {
        int[] empty = new int[]{};
        return new Plottable(empty, empty);
    }

    public static void debugExtraPixel(TimeRange correctedSeisRange, Instant rangeEnd, LocalSeismogramImpl seis, int startPoint, int endPoint, int numPixels, IntRange seisPixelRange, int startPixel, Duration pixelPeriod) {
        logger.warn("corrected for freak extra pixel!");
        logger.debug("correctedSeisRange: " + String.valueOf(correctedSeisRange));
        logger.debug("end of range would have been " + String.valueOf(rangeEnd) + " without correction");
        logger.debug("seis.num_points: " + seis.num_points);
        logger.debug("startPoint: " + startPoint);
        logger.debug("endPoint: " + endPoint);
        logger.debug("seisPixelRange: " + String.valueOf(seisPixelRange));
        logger.debug("numPixels after correction: " + numPixels);
        logger.debug("startPixel: " + startPixel);
        logger.debug("pixelPeriod: " + String.valueOf(pixelPeriod));
    }

    public static Duration getPixelPeriod(int pixelsPerDay) {
        double pixelPeriod = 1.0 / (double)pixelsPerDay;
        return ClockUtil.durationFrom(pixelPeriod, UnitImpl.DAY);
    }

    public static Instant getBeginningOfDay(Instant date) {
        ZonedDateTime zdt = ZonedDateTime.ofInstant(date, TimeUtils.TZ_UTC);
        zdt = ZonedDateTime.of(zdt.getYear(), zdt.getMonthValue(), zdt.getDayOfMonth(), 0, 0, 0, 0, TimeUtils.TZ_UTC);
        return zdt.toInstant();
    }

    public static TimeRange getDay(Instant date) {
        return new TimeRange(SimplePlotUtil.getBeginningOfDay(date), ONE_DAY);
    }

    public static Instant getPixelBeginTime(TimeRange day, int pixel, int pixelsPerDay) {
        Duration pixelPeriod = SimplePlotUtil.getPixelPeriod(pixelsPerDay);
        return day.getBeginTime().plus(pixelPeriod.multipliedBy(pixel));
    }

    public static TimeRange getPixelTimeRange(Instant point, int pixelsPerDay, boolean after) {
        Duration pixelPeriod = SimplePlotUtil.getPixelPeriod(pixelsPerDay);
        TimeRange day = SimplePlotUtil.getDay(point);
        int pixel = SimplePlotUtil.getPixel(pixelsPerDay, day, point);
        if (after) {
            ++pixel;
        }
        Instant pixelBegin = SimplePlotUtil.getPixelBeginTime(day, pixel, pixelsPerDay);
        return new TimeRange(pixelBegin, pixelPeriod);
    }

    public static IntRange getDayPixelRange(LocalSeismogramImpl seis, int pixelsPerDay) {
        return SimplePlotUtil.getDayPixelRange(seis, pixelsPerDay, SimplePlotUtil.getBeginningOfDay(seis.begin_time));
    }

    public static IntRange getDayPixelRange(LocalSeismogramImpl seis, int pixelsPerDay, Instant startOfDay) {
        int endPixel;
        TimeRange seisTR = new TimeRange(seis);
        TimeRange dayTR = new TimeRange(startOfDay, ONE_DAY);
        int startPixel = SimplePlotUtil.getPixel(pixelsPerDay, dayTR, seisTR.getBeginTime());
        if (SimplePlotUtil.getPixelTimeRange(seisTR.getBeginTime(), pixelsPerDay, false).getBeginTime().isBefore(seisTR.getBeginTime())) {
            ++startPixel;
        }
        if ((endPixel = SimplePlotUtil.getPixel(pixelsPerDay, dayTR, seisTR.getEndTime())) < startPixel) {
            endPixel = startPixel;
        }
        return new IntRange(startPixel, endPixel);
    }

    public static boolean canMakeAtLeastOnePixel(LocalSeismogramImpl seis, int pixelsPerDay) {
        IntRange pixelRange = SimplePlotUtil.getDayPixelRange(seis, pixelsPerDay);
        return pixelRange.getMax() > pixelRange.getMin();
    }

    public static TimeRange correctTimeRangeForPixelData(LocalSeismogramImpl seis, int pixelsPerDay) {
        IntRange pixelRange = SimplePlotUtil.getDayPixelRange(seis, pixelsPerDay);
        TimeRange day = SimplePlotUtil.getDay(seis.begin_time);
        Instant start = SimplePlotUtil.getPixelBeginTime(day, pixelRange.getMin(), pixelsPerDay);
        Instant end = SimplePlotUtil.getPixelBeginTime(day, pixelRange.getMax(), pixelsPerDay);
        return new TimeRange(start, end);
    }

    public static int[][] compressXvalues(LocalSeismogramImpl seismogram, TimeRange timeRange, Dimension size) throws CodecException {
        LocalSeismogramImpl seis = seismogram;
        int width = size.width;
        int[][] out = new int[2][];
        if (seis.getEndTime().isBefore(timeRange.getBeginTime()) || seis.getBeginTime().isAfter(timeRange.getEndTime())) {
            out[0] = new int[0];
            out[1] = new int[0];
            logger.info("The end time is before the beginTime in simple seismogram");
            return out;
        }
        Instant tMin = timeRange.getBeginTime();
        Instant tMax = timeRange.getEndTime();
        int seisStartIndex = SimplePlotUtil.getPoint(seis, tMin);
        int seisEndIndex = SimplePlotUtil.getPoint(seis, tMax);
        if (seisStartIndex < 0) {
            seisStartIndex = 0;
        }
        if (seisEndIndex >= seis.getNumPoints()) {
            seisEndIndex = seis.getNumPoints() - 1;
        }
        Instant tempdate = SimplePlotUtil.getValue(seis.getNumPoints(), seis.getBeginTime(), seis.getEndTime(), seisStartIndex);
        int pixelStartIndex = SimplePlotUtil.getPixel(width, timeRange, tempdate);
        tempdate = SimplePlotUtil.getValue(seis.getNumPoints(), seis.getBeginTime(), seis.getEndTime(), seisEndIndex);
        int pixelEndIndex = SimplePlotUtil.getPixel(width, timeRange, tempdate);
        int pixels = seisEndIndex - seisStartIndex + 1;
        out[0] = new int[2 * pixels];
        out[1] = new int[out[0].length];
        int[] tempYvalues = new int[out[0].length];
        int seisIndex = seisStartIndex;
        int numAdded = 0;
        int xvalue = Math.round((float)SimplePlotUtil.linearInterp(seisStartIndex, pixelStartIndex, seisEndIndex, pixelEndIndex, seisIndex));
        int tempValue = 0;
        ++seisIndex;
        int j = 0;
        while (seisIndex <= seisEndIndex) {
            tempValue = Math.round((float)SimplePlotUtil.linearInterp(seisStartIndex, pixelStartIndex, seisEndIndex, pixelEndIndex, seisIndex));
            tempYvalues[j++] = (int)seis.getValueAt(seisIndex).getValue();
            if (tempValue != xvalue) {
                out[0][numAdded] = xvalue;
                out[0][numAdded + 1] = xvalue;
                out[1][numAdded] = SimplePlotUtil.getMinValue(tempYvalues, 0, j - 1);
                out[1][numAdded + 1] = SimplePlotUtil.getMaxValue(tempYvalues, 0, j - 1);
                j = 0;
                xvalue = tempValue;
                numAdded += 2;
            }
            ++seisIndex;
        }
        int[][] temp = new int[2][numAdded];
        System.arraycopy(out[0], 0, temp[0], 0, numAdded);
        System.arraycopy(out[1], 0, temp[1], 0, numAdded);
        return temp;
    }

    private static int getMinValue(int[] yValues, int startIndex, int endIndex) {
        int minValue = Integer.MAX_VALUE;
        for (int i = startIndex; i <= endIndex; ++i) {
            if (yValues[i] >= minValue) continue;
            minValue = yValues[i];
        }
        return minValue;
    }

    private static int getMaxValue(int[] yValues, int startIndex, int endIndex) {
        int maxValue = Integer.MIN_VALUE;
        for (int i = startIndex; i <= endIndex; ++i) {
            if (yValues[i] <= maxValue) continue;
            maxValue = yValues[i];
        }
        return maxValue;
    }

    @Deprecated
    public static final double linearInterp(double xa, double ya, double xb, double yb, double x) {
        return LinearInterp.linearInterp(xa, ya, xb, yb, x);
    }

    public static final int getPixel(int totalPixels, TimeRange tr, Instant value) {
        return SimplePlotUtil.getPixel(totalPixels, tr.getBeginTime(), tr.getEndTime(), value);
    }

    public static final int getPoint(LocalSeismogramImpl seis, Instant time) {
        return SimplePlotUtil.getPixel(seis.getNumPoints(), seis.getBeginTime(), seis.getEndTime(), time);
    }

    public static final int getPixel(int totalPixels, Instant begin, Instant end, Instant value) {
        return SimplePlotUtil.getPixel(0, totalPixels, begin, end, value);
    }

    public static final int getPixel(int startPixel, int endPixel, Instant begin, Instant end, Instant value) {
        return (int)SimplePlotUtil.linearInterp(TimeUtils.instantToEpochSeconds((Instant)begin), startPixel, TimeUtils.instantToEpochSeconds((Instant)end), endPixel, TimeUtils.instantToEpochSeconds((Instant)value));
    }

    public static final Instant getValue(int totalPixels, Instant begin, Instant end, int pixel) {
        return SimplePlotUtil.getValue(0, totalPixels, begin, end, pixel);
    }

    public static final Instant getValue(int startPixel, int endPixel, Instant begin, Instant end, int pixel) {
        double value = SimplePlotUtil.linearInterp(startPixel, 0.0, endPixel, Duration.between(begin, end).toNanos(), pixel);
        Duration d = Duration.ofNanos(Math.round(value));
        return begin.plus(d);
    }

    public static final int getPixel(int totalPixels, UnitRangeImpl range, QuantityImpl value) {
        QuantityImpl converted = value.convertTo(range.getUnit());
        return SimplePlotUtil.getPixel(totalPixels, range, converted.getValue());
    }

    public static final int getPixel(int totalPixels, UnitRangeImpl range, double value) {
        return (int)SimplePlotUtil.linearInterp(range.getMinValue(), 0.0, range.getMaxValue(), totalPixels, value);
    }

    public static final QuantityImpl getValue(int totalPixels, UnitRangeImpl range, int pixel) {
        double value = SimplePlotUtil.linearInterp(0.0, range.getMinValue(), totalPixels, range.getMaxValue(), pixel);
        return new QuantityImpl(value, range.getUnit());
    }

    public static final Instant getTimeForIndex(int index, Instant beginTime, SamplingImpl sampling) {
        Duration width = sampling.getPeriod();
        width = width.multipliedBy(index);
        return beginTime.plus(width);
    }

    public static List<PlottableChunk> makePlottables(LocalSeismogramImpl[] seis, int pixelsPerDay) throws IOException {
        ArrayList<PlottableChunk> chunks = new ArrayList<PlottableChunk>();
        for (int i = 0; i < seis.length; ++i) {
            LocalSeismogramImpl curSeis = seis[i];
            if (curSeis.getNumPoints() <= 0 || !SimplePlotUtil.canMakeAtLeastOnePixel(seis[i], pixelsPerDay)) continue;
            try {
                Plottable plott = SimplePlotUtil.makePlottable(curSeis, pixelsPerDay);
                if (plott.x_coor.length <= 0) continue;
                Instant plotStartTime = SimplePlotUtil.getBeginningOfDay(curSeis.getBeginTime());
                PlottableChunk chunk = new PlottableChunk(plott, SimplePlotUtil.getDayPixelRange(seis[i], pixelsPerDay, plotStartTime).getMin(), plotStartTime, pixelsPerDay, curSeis.channel_id.getNetworkId(), curSeis.channel_id.getStationCode(), curSeis.channel_id.getLocCode(), curSeis.channel_id.getChannelCode());
                chunks.add(chunk);
                continue;
            }
            catch (CodecException e) {
                logger.warn("unable to make plottable for " + String.valueOf(curSeis) + ", skipping.", (Throwable)e);
            }
        }
        return chunks;
    }

    public static List<PlottableChunk> convertToCommonPixelScale(List<PlottableChunk> chunks, TimeRange requestRange, int pixelsPerDay) {
        int requestPixels = SimplePlotUtil.getPixels(pixelsPerDay, requestRange);
        ArrayList<PlottableChunk> outChunks = new ArrayList<PlottableChunk>();
        for (PlottableChunk pc : chunks) {
            if (pc.getEndTime().isBefore(requestRange.getBeginTime())) continue;
            Instant rowBeginTime = pc.getBeginTime();
            int offsetIntoRequestPixels = SimplePlotUtil.getPixel(requestPixels, requestRange, rowBeginTime);
            int numPixels = pc.getNumPixels();
            int firstPixelForRequest = 0;
            if (offsetIntoRequestPixels < 0) {
                firstPixelForRequest = -1 * offsetIntoRequestPixels;
            }
            int lastPixelForRequest = numPixels;
            if (offsetIntoRequestPixels + numPixels > requestPixels) {
                lastPixelForRequest = requestPixels - offsetIntoRequestPixels;
            }
            if (firstPixelForRequest > lastPixelForRequest) {
                throw new NegativeArraySizeException("first pixel > last pixel: f=" + firstPixelForRequest + "  l=" + lastPixelForRequest);
            }
            int pixelsUsed = lastPixelForRequest - firstPixelForRequest;
            int[] x = new int[pixelsUsed * 2];
            int[] y = new int[pixelsUsed * 2];
            int[] ploty = pc.getYData();
            System.arraycopy(ploty, firstPixelForRequest * 2, y, 0, pixelsUsed * 2);
            for (int i = 0; i < pixelsUsed * 2; ++i) {
                x[i] = firstPixelForRequest + offsetIntoRequestPixels + i / 2;
            }
            Plottable p = new Plottable(x, y);
            PlottableChunk shiftPC = new PlottableChunk(p, SimplePlotUtil.getPixel(rowBeginTime, pixelsPerDay) + firstPixelForRequest, PlottableChunk.getJDay(rowBeginTime), PlottableChunk.getYear(rowBeginTime), pixelsPerDay, pc.getNetworkCode(), pc.getStationCode(), pc.getSiteCode(), pc.getChannelCode());
            outChunks.add(shiftPC);
        }
        return outChunks;
    }

    public static int getPixels(int pixelsPerDay, TimeRange tr) {
        Duration inter = tr.getInterval();
        double interDays = (double)inter.toNanos() / 8.64E13;
        double samples = (double)pixelsPerDay * interDays;
        return (int)Math.floor(samples);
    }

    public static int getPixel(Instant time, int pixelsPerDay) {
        Instant day = PlottableChunk.stripToDay(time);
        TimeRange tr = new TimeRange(day, ONE_DAY);
        double pixel = SimplePlotUtil.getPixel(pixelsPerDay, tr, time);
        return (int)Math.floor(pixel);
    }
}

