/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.util.display;

import edu.sc.seis.sod.model.event.FlinnEngdahlRegion;
import edu.sc.seis.sod.model.event.FlinnEngdahlType;
import edu.sc.seis.sod.util.display.GeographicRegion;
import edu.sc.seis.sod.util.display.SeismicRegion;
import java.io.IOException;
import java.io.InputStream;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.Properties;

public class ParseRegions {
    private static ParseRegions singleton = null;
    public static final String FE_REGION_PROP = "edu/sc/seis/sod/util/display/FERegions.prop";
    public static final int NUM_SEISMIC_REGIONS = 50;
    public static final int NUM_GEOGRAPHIC_REGIONS = 757;
    private SeismicRegion[] seisRegions = new SeismicRegion[50];
    private GeographicRegion[] geogRegions = new GeographicRegion[757];

    private ParseRegions() {
        this.load();
    }

    public static ParseRegions getInstance() {
        if (singleton == null) {
            singleton = new ParseRegions();
        }
        return singleton;
    }

    public int getRegionValue(String region) {
        for (int i = 0; i < this.geogRegions.length; ++i) {
            if (!this.geogRegions[i].getName().equals(region)) continue;
            return this.geogRegions[i].getNumber();
        }
        return 0;
    }

    public int getSeismicRegionValue(String region) {
        for (int i = 0; i < this.seisRegions.length; ++i) {
            if (!this.seisRegions[i].getName().equals(region)) continue;
            return this.seisRegions[i].getNumber();
        }
        return 0;
    }

    public GeographicRegion getGeographicRegion(int geoNum) {
        if (geoNum <= 757 && geoNum > 0) {
            return this.geogRegions[geoNum - 1];
        }
        return new GeographicRegion(new SeismicRegion("Unknown", 0), "Unknown (" + geoNum + ")", geoNum);
    }

    public String getGeographicRegionName(int geoNum) {
        if (geoNum == 0) {
            return "Unknown";
        }
        return this.getGeographicRegion(geoNum).getName();
    }

    public String getSeismicRegionName(int seisNum) {
        if (seisNum <= 50 && seisNum > 0) {
            return this.seisRegions[seisNum - 1].getName();
        }
        return "SeisRegion" + seisNum;
    }

    public String getRegionName(FlinnEngdahlRegion region) {
        if (region != null && region.type != null) {
            if (region.type.equals(FlinnEngdahlType.SEISMIC_REGION)) {
                return this.getSeismicRegionName(region.number);
            }
            if (region.type.equals(FlinnEngdahlType.GEOGRAPHIC_REGION)) {
                return this.getGeographicRegionName(region.number);
            }
        }
        return "Unknown";
    }

    public SeismicRegion[] getAllSeismicRegions() {
        return this.seisRegions;
    }

    public SeismicRegion[] getAlphabetizedSeismicRegions() {
        SeismicRegion[] alphaRegions = new SeismicRegion[50];
        for (int i = 0; i < 50; ++i) {
            alphaRegions[i] = this.seisRegions[i];
        }
        Arrays.sort(alphaRegions, new RegionAlphabetizer());
        return alphaRegions;
    }

    protected void load() {
        try {
            int i;
            ClassLoader loader = this.getClass().getClassLoader();
            InputStream fstream = loader.getResourceAsStream(FE_REGION_PROP);
            if (fstream == null) {
                throw new RuntimeException("Cannot load FE regions from edu/sc/seis/sod/util/display/FERegions.prop, stream is null");
            }
            Properties feProps = new Properties();
            feProps.load(fstream);
            for (i = 1; i < 51; ++i) {
                String regionName = feProps.getProperty("SeismicRegion" + i);
                this.seisRegions[i - 1] = new SeismicRegion(regionName, i);
            }
            for (i = 1; i < 758; ++i) {
                String geogName = feProps.getProperty("GeogRegion" + i);
                int seisRegNum = Integer.parseInt(feProps.getProperty("GeoToSeisMap" + i));
                SeismicRegion parent = this.seisRegions[seisRegNum - 1];
                this.geogRegions[i - 1] = new GeographicRegion(parent, geogName, i);
                parent.add(this.geogRegions[i - 1]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load FE regions from edu/sc/seis/sod/util/display/FERegions.prop", e);
        }
    }

    private class RegionAlphabetizer
    implements Comparator {
        private Collator alphaCol = Collator.getInstance(Locale.US);

        private RegionAlphabetizer() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof SeismicRegion && o2 instanceof SeismicRegion) {
                SeismicRegion seis1 = (SeismicRegion)o1;
                SeismicRegion seis2 = (SeismicRegion)o2;
                return this.alphaCol.compare(seis1.getName(), seis2.getName());
            }
            return 0;
        }
    }
}

