/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.util.display;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.sod.model.common.QuantityImpl;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.event.Magnitude;
import edu.sc.seis.sod.model.event.OriginImpl;
import edu.sc.seis.sod.util.display.ParseRegions;
import edu.sc.seis.sod.util.display.ThreadSafeDecimalFormat;
import edu.sc.seis.sod.util.display.UnitDisplayUtil;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventUtil {
    private static ThreadSafeDecimalFormat depthFormatter = new ThreadSafeDecimalFormat("###0.00");
    public static final String LOC = "LOC";
    public static final String TIME = "TIME";
    public static final String MAG = "MAG";
    public static final String DEPTH = "DEPTH";
    public static final String DEPTH_UNIT = "DEPTH_UNIT";
    public static final String LAT = "LAT";
    public static final String LON = "LON";
    public static final String CAT = "CAT";
    public static final String CONTRIB = "CONTRIB";
    private static final String[] magicStrings = new String[]{"LOC", "TIME", "MAG", "DEPTH", "DEPTH_UNIT", "LAT", "LON", "CAT", "CONTRIB"};
    public static final String NO_ARG_STRING = "Event: LOC | TIME | Mag: MAG | Depth DEPTH DEPTH_UNIT | (LAT, LON)";
    public static List PREFERRED_MAG_TYPES;
    private static final Logger logger;

    @Deprecated
    public static OriginImpl extractOrigin(CacheEvent ev) {
        return ev.extractOrigin();
    }

    public static Magnitude[] sortByValue(Magnitude[] mags) {
        ArrayList<ComparableValueMagnitudeWrapper> compMagList = new ArrayList<ComparableValueMagnitudeWrapper>();
        for (int i = 0; i < mags.length; ++i) {
            compMagList.add(new ComparableValueMagnitudeWrapper(mags[i]));
        }
        return EventUtil.sortAndExtract(compMagList);
    }

    public static Magnitude getSmallest(Magnitude[] mags) {
        return EventUtil.sortByValue(mags)[0];
    }

    public static Magnitude getLargest(Magnitude[] mags) {
        return EventUtil.sortByValue(mags)[mags.length - 1];
    }

    public static Magnitude[] sortByType(Magnitude[] mags) {
        ArrayList<ComparableTypeMagnitudeWrapper> compMagList = new ArrayList<ComparableTypeMagnitudeWrapper>();
        for (int i = 0; i < mags.length; ++i) {
            compMagList.add(new ComparableTypeMagnitudeWrapper(mags[i]));
        }
        return EventUtil.sortAndExtract(compMagList);
    }

    public static Magnitude getBestByType(Magnitude[] mags) {
        return EventUtil.sortByType(mags)[0];
    }

    private static Magnitude[] sortAndExtract(List wrappedComparableMagnitudes) {
        Collections.sort(wrappedComparableMagnitudes);
        Magnitude[] sortedMags = new Magnitude[wrappedComparableMagnitudes.size()];
        for (int i = 0; i < wrappedComparableMagnitudes.size(); ++i) {
            sortedMags[i] = ((ComparableMagnitudeWrapper)wrappedComparableMagnitudes.get((int)i)).mag;
        }
        return sortedMags;
    }

    public static String getEventInfo(CacheEvent event) {
        return EventUtil.getEventInfo(event, NO_ARG_STRING);
    }

    public static String getEventInfo(CacheEvent event, String format) {
        return EventUtil.getEventInfo(event, format, TimeUtils.createFormatter((String)"MM/dd/yyyy HH:mm:ss z"));
    }

    public static String getEventInfo(CacheEvent event, String format, DateTimeFormatter sdf) {
        OriginImpl origin = EventUtil.extractOrigin(event);
        StringBuffer buf = new StringBuffer(format);
        int index = buf.indexOf(LOC);
        if (index != -1) {
            ParseRegions regions = ParseRegions.getInstance();
            String location = regions.getGeographicRegionName(event.get_attributes().region.number);
            buf.delete(index, index + LOC.length());
            buf.insert(index, location);
        }
        return EventUtil.getOriginInfo(origin, buf.toString(), sdf);
    }

    public static String getOriginInfo(OriginImpl origin) {
        return EventUtil.getOriginInfo(origin, NO_ARG_STRING);
    }

    public static String getOriginInfo(OriginImpl origin, String format) {
        return EventUtil.getOriginInfo(origin, format, TimeUtils.createFormatter((String)"MM/dd/yyyy HH:mm:ss z"));
    }

    public static String getOriginInfo(OriginImpl origin, String format, DateTimeFormatter sdf) {
        Instant msd = origin.getOriginTime();
        String originTimeString = msd.toString();
        float mag = Float.NaN;
        if (origin.getMagnitudes().length > 0) {
            mag = origin.getMagnitudes()[0].value;
        }
        QuantityImpl depth = origin.getLocation().depth;
        float latitude = origin.getLocation().latitude;
        float longitude = origin.getLocation().longitude;
        String catalog = origin.getCatalog();
        String contributor = origin.getContributor();
        StringBuffer buf = new StringBuffer(format);
        for (int i = 0; i < magicStrings.length; ++i) {
            int index = buf.indexOf(magicStrings[i]);
            if (index == -1) continue;
            buf.delete(index, index + magicStrings[i].length());
            if (magicStrings[i].equals(TIME)) {
                buf.insert(index, originTimeString);
                continue;
            }
            if (magicStrings[i].equals(MAG)) {
                if (Float.isNaN(mag)) {
                    buf.insert(index, "...");
                    continue;
                }
                buf.insert(index, mag);
                continue;
            }
            if (magicStrings[i].equals(DEPTH)) {
                buf.insert(index, depthFormatter.format(depth.getValue()));
                continue;
            }
            if (magicStrings[i].equals(DEPTH_UNIT)) {
                buf.insert(index, UnitDisplayUtil.getNameForUnit(depth.getUnit()));
                continue;
            }
            if (magicStrings[i].equals(LAT)) {
                buf.insert(index, latitude);
                continue;
            }
            if (magicStrings[i].equals(LON)) {
                buf.insert(index, longitude);
                continue;
            }
            if (magicStrings[i].equals(CAT)) {
                buf.insert(index, catalog);
                continue;
            }
            if (!magicStrings[i].equals(CONTRIB)) continue;
            buf.insert(index, contributor);
        }
        return buf.toString();
    }

    static {
        String[] prefMagTypes = new String[]{"MO", "Mo", "MW", "Mw", "MS", "Ms", "MB", "Mb", "ML", "Ml", "M"};
        PREFERRED_MAG_TYPES = Arrays.asList(prefMagTypes);
        logger = LoggerFactory.getLogger(EventUtil.class);
    }

    private static class ComparableValueMagnitudeWrapper
    extends ComparableMagnitudeWrapper {
        public ComparableValueMagnitudeWrapper(Magnitude mag) {
            super(mag);
        }

        public int compareTo(Object obj) {
            ComparableValueMagnitudeWrapper compMag = (ComparableValueMagnitudeWrapper)obj;
            return Float.compare(this.mag.value, compMag.mag.value);
        }
    }

    private static class ComparableTypeMagnitudeWrapper
    extends ComparableMagnitudeWrapper {
        public ComparableTypeMagnitudeWrapper(Magnitude mag) {
            super(mag);
        }

        public int compareTo(Object obj) {
            ComparableTypeMagnitudeWrapper compMag = (ComparableTypeMagnitudeWrapper)obj;
            if (PREFERRED_MAG_TYPES.contains(this.mag.type)) {
                if (PREFERRED_MAG_TYPES.contains(compMag.mag.type)) {
                    return PREFERRED_MAG_TYPES.indexOf(this.mag.type) - PREFERRED_MAG_TYPES.indexOf(compMag.mag.type);
                }
                return -1;
            }
            if (PREFERRED_MAG_TYPES.contains(compMag.mag.type)) {
                return 1;
            }
            return this.mag.type.compareTo(compMag.mag.type);
        }
    }

    private static abstract class ComparableMagnitudeWrapper
    implements Comparable {
        Magnitude mag;

        public ComparableMagnitudeWrapper(Magnitude mag) {
            this.mag = mag;
        }
    }
}

