/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.util.display;

import edu.sc.seis.sod.util.display.ThreadSafeDecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class ChoiceDecimalFormat
extends NumberFormat {
    private double[] limits;
    private ThreadSafeDecimalFormat[] formats;

    public ChoiceDecimalFormat(double[] limits, ThreadSafeDecimalFormat[] formats) {
        if (limits.length != formats.length) {
            throw new IllegalArgumentException("Must be an equal number of limits and formats");
        }
        this.limits = limits;
        this.formats = formats;
    }

    @Override
    public Number parse(String source, ParsePosition parsePosition) {
        throw new UnsupportedOperationException("ChoiceDecimalFormat aint your number parser.  Use one of the java classes DecimalFormat or ChoiceFormat");
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        for (int i = 0; i < this.limits.length; ++i) {
            if (!(number < this.limits[i])) continue;
            return this.formats[i].format(number, toAppendTo, pos);
        }
        return this.formats[this.formats.length - 1].format(number, toAppendTo, pos);
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        for (int i = 0; i < this.limits.length; ++i) {
            if (!((double)number < this.limits[i])) continue;
            return this.formats[i].format(number, toAppendTo, pos);
        }
        return this.formats[this.formats.length - 1].format(number, toAppendTo, pos);
    }

    public static ChoiceDecimalFormat createTomStyleA() {
        return new ChoiceDecimalFormat(new double[]{100.0, 100.0}, new ThreadSafeDecimalFormat[]{new ThreadSafeDecimalFormat("0.0"), new ThreadSafeDecimalFormat("0")});
    }

    public static ChoiceDecimalFormat createTomStyleB() {
        return new ChoiceDecimalFormat(new double[]{10.0, 10.0}, new ThreadSafeDecimalFormat[]{new ThreadSafeDecimalFormat("0.0"), new ThreadSafeDecimalFormat("0")});
    }
}

