/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.util.convert.wav;

import edu.iris.dmc.seedcodec.CodecException;
import edu.sc.seis.seisFile.mseed.Utility;
import edu.sc.seis.sod.model.common.FissuresException;
import edu.sc.seis.sod.model.common.QuantityImpl;
import edu.sc.seis.sod.model.common.SamplingImpl;
import edu.sc.seis.sod.model.common.TimeRange;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import java.io.DataOutput;
import java.io.IOException;
import javax.sound.sampled.Clip;
import javax.swing.event.EventListenerList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FissuresToWAV {
    private int chunkSize;
    private int numChannels;
    private int sampleRate;
    private int speedUp;
    private int bitsPerSample;
    private int blockAlign;
    private int byteRate;
    private int subchunk2Size;
    private Clip clip;
    LocalSeismogramImpl seis;
    private EventListenerList listenerList = new EventListenerList();
    private static Logger logger = LoggerFactory.getLogger((String)FissuresToWAV.class.getName());

    public FissuresToWAV(LocalSeismogramImpl seis, int speedUp) {
        this.seis = seis;
        this.speedUp = speedUp;
        this.numChannels = 1;
        this.bitsPerSample = 16;
        this.blockAlign = this.numChannels * (this.bitsPerSample / 8);
    }

    public void writeWAV(DataOutput out, TimeRange tr) throws IOException, FissuresException, CodecException {
        this.updateInfo();
        this.writeChunkData(out);
        this.writeWAVData(out);
    }

    private void updateInfo() {
        this.chunkSize = 36 + 2 * this.seis.getNumPoints();
        this.subchunk2Size = this.seis.getNumPoints() * this.blockAlign;
        this.sampleRate = this.calculateSampleRate(this.seis.getSampling());
        this.byteRate = this.sampleRate * this.blockAlign;
    }

    public void setSpeedUp(int newSpeed) {
        this.speedUp = newSpeed;
        this.updateInfo();
    }

    private void writeChunkData(DataOutput out) throws IOException {
        out.writeBytes("RIFF");
        FissuresToWAV.writeLittleEndian(out, this.chunkSize);
        out.writeBytes("WAVE");
        out.writeBytes("fmt ");
        FissuresToWAV.writeLittleEndian(out, 16);
        FissuresToWAV.writeLittleEndian(out, (short)1);
        FissuresToWAV.writeLittleEndian(out, (short)this.numChannels);
        FissuresToWAV.writeLittleEndian(out, this.sampleRate);
        FissuresToWAV.writeLittleEndian(out, this.byteRate);
        FissuresToWAV.writeLittleEndian(out, (short)this.blockAlign);
        FissuresToWAV.writeLittleEndian(out, (short)this.bitsPerSample);
        out.writeBytes("data");
        FissuresToWAV.writeLittleEndian(out, this.subchunk2Size);
    }

    private void writeWAVData(DataOutput out) throws IOException, CodecException, FissuresException {
        double max = this.seis.getMaxValue().getValue();
        double min = this.seis.getMinValue().getValue();
        double absMax = Double.MAX_VALUE;
        absMax = Math.abs(min) > Math.abs(max) ? Math.abs(min) : Math.abs(max);
        double amplification = 32000.0 / absMax;
        try {
            if (this.seis.can_convert_to_long()) {
                int[] data = this.seis.get_as_longs();
                for (int i = 0; i < data.length; ++i) {
                    FissuresToWAV.writeLittleEndian(out, (short)(amplification * (double)data[i]));
                }
            } else {
                double[] data = this.seis.get_as_doubles();
                for (int i = 0; i < data.length; ++i) {
                    FissuresToWAV.writeLittleEndian(out, (short)(amplification * data[i]));
                }
            }
        }
        catch (NullPointerException e) {
            FissuresToWAV.writeLittleEndian(out, (short)0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            FissuresToWAV.writeLittleEndian(out, (short)0);
        }
    }

    public int calculateSampleRate(SamplingImpl sampling) {
        QuantityImpl freq = sampling.getFrequency();
        freq = freq.convertTo(UnitImpl.HERTZ);
        int sampleRate = (int)(freq.getValue() * (double)this.speedUp);
        while (sampleRate > 48000) {
            this.setSpeedUp(this.speedUp / 2);
            logger.debug("speedUp = " + this.speedUp);
            sampleRate = (int)(freq.getValue() * (double)this.speedUp);
            logger.debug("sampleRate = " + sampleRate);
        }
        return sampleRate;
    }

    protected static void writeLittleEndian(DataOutput out, int value) throws IOException {
        byte[] tmpBytes = Utility.intToByteArray((int)value);
        out.write(tmpBytes[3]);
        out.write(tmpBytes[2]);
        out.write(tmpBytes[1]);
        out.write(tmpBytes[0]);
    }

    protected static void writeLittleEndian(DataOutput out, short value) throws IOException {
        byte[] tmpBytes = Utility.intToByteArray((int)value);
        out.write(tmpBytes[3]);
        out.write(tmpBytes[2]);
    }
}

