/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.util.convert.stationxml;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.stationxml.FloatType;
import edu.sc.seis.seisFile.fdsnws.stationxml.Unit;
import edu.sc.seis.sod.model.common.QuantityImpl;
import edu.sc.seis.sod.model.common.UnitBase;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.common.UnknownUnit;
import java.time.Duration;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StationXMLToFissures {
    public static final String UNKNOWN = "";
    public static final Duration ONE_SECOND = TimeUtils.ONE_SECOND;
    public static final String WAY_FUTURE = "24990101T00:00:00.000";
    public static final String WAY_PAST = "10010101T00:00:00.000";
    private static final Logger logger = LoggerFactory.getLogger(StationXMLToFissures.class);

    public static QuantityImpl convertFloatType(FloatType val) throws UnknownUnit {
        return new QuantityImpl(val.getValue(), StationXMLToFissures.convertUnit(val.getUnit(), UNKNOWN));
    }

    public static UnitImpl convertUnit(Unit unit) throws UnknownUnit {
        String unitString = unit.getName().indexOf(" - ") != -1 ? unit.getName().substring(0, unit.getName().indexOf(" - ")).trim() : unit.getName().trim();
        if (unitString.length() == 0) {
            throw new UnknownUnit(unit);
        }
        return StationXMLToFissures.convertUnit(unitString, unit.getDescription());
    }

    public static UnitImpl convertUnit(String unitString, String unitDescription) throws UnknownUnit {
        if (unitDescription == null) {
            unitDescription = UNKNOWN;
        }
        unitString = unitString.trim();
        unitDescription = unitDescription.trim();
        if (unitString.equalsIgnoreCase("M") && !unitDescription.trim().equalsIgnoreCase("minute")) {
            return UnitImpl.METER;
        }
        if (unitString.equalsIgnoreCase("M") && unitDescription.trim().equalsIgnoreCase("minute")) {
            return UnitImpl.MINUTE;
        }
        if (unitString.equalsIgnoreCase("NM")) {
            return UnitImpl.NANOMETER;
        }
        if (unitString.equalsIgnoreCase("M/S")) {
            return UnitImpl.METER_PER_SECOND;
        }
        if (unitString.equalsIgnoreCase("NM/S") || unitString.equalsIgnoreCase("NM/SEC")) {
            return UnitImpl.NANOMETER_PER_SECOND;
        }
        if (unitString.equalsIgnoreCase("CM/SEC**2")) {
            return UnitImpl.CENTIMETER_PER_SECOND_PER_SECOND;
        }
        if (unitString.equalsIgnoreCase("M/S/S") || unitString.equalsIgnoreCase("M/S**2") || unitString.equalsIgnoreCase("M/(S**2)") || unitString.equalsIgnoreCase("M/S**2/ACCELERATION")) {
            return UnitImpl.METER_PER_SECOND_PER_SECOND;
        }
        if (unitString.equalsIgnoreCase("PA") || unitString.equalsIgnoreCase("PASSCAL") || unitString.equalsIgnoreCase("PASSCALS")) {
            return UnitImpl.PASCAL;
        }
        if (unitString.equalsIgnoreCase("HPA") || unitString.equalsIgnoreCase("HECTOPASCALS")) {
            return UnitImpl.HECTOPASCAL;
        }
        if (unitString.equalsIgnoreCase("KPA") || unitString.equalsIgnoreCase("KILOPASCALS")) {
            return UnitImpl.KILOPASCAL;
        }
        if (unitString.equalsIgnoreCase("H/M**2*S")) {
            return UnitImpl.multiply(UnitImpl.SQUARE_METER, UnitImpl.SECOND).inverse("hail intensity in hits per meter squared second");
        }
        if (unitString.equalsIgnoreCase("PERCENT") || unitString.equalsIgnoreCase("P") || unitString.equalsIgnoreCase("%")) {
            return new UnitImpl(UnitBase.COUNT, -2, "PERCENT", 1.0, 1);
        }
        if (unitString.equalsIgnoreCase("MBAR")) {
            return UnitImpl.MILLIBAR;
        }
        if (unitString.equalsIgnoreCase("C") || unitString.equalsIgnoreCase("TC") || unitString.equalsIgnoreCase("CELSIUS") || unitString.equalsIgnoreCase("DEGC")) {
            return UnitImpl.CELSIUS;
        }
        if (unitString.equalsIgnoreCase("S") || unitString.equalsIgnoreCase("SEC")) {
            return UnitImpl.SECOND;
        }
        if (unitString.equalsIgnoreCase("USEC")) {
            return UnitImpl.MICROSECOND;
        }
        if (unitString.equalsIgnoreCase("A") || unitString.equalsIgnoreCase("AMPERES")) {
            return UnitImpl.AMPERE;
        }
        if (unitString.equalsIgnoreCase("T")) {
            return UnitImpl.TESLA;
        }
        if (unitString.equalsIgnoreCase("NT")) {
            return UnitImpl.multiply(1.0E-9, UnitImpl.TESLA, "NANOTESLA");
        }
        if (unitString.equalsIgnoreCase("V") || unitString.equalsIgnoreCase("VOLTS") || unitString.equalsIgnoreCase("VOLT_UNIT")) {
            return UnitImpl.VOLT;
        }
        if (unitString.equalsIgnoreCase("MILLIVOLTS")) {
            return UnitImpl.multiply(0.001, UnitImpl.VOLT, "MILLIVOLT");
        }
        if (unitString.equalsIgnoreCase("V/M")) {
            return UnitImpl.VOLT_PER_METER;
        }
        if (unitString.equalsIgnoreCase("W/M2") || unitString.equalsIgnoreCase("WATTS/M^2")) {
            return UnitImpl.divide(UnitImpl.WATT, UnitImpl.SQUARE_METER);
        }
        if (unitString.equalsIgnoreCase("RAD") || unitString.equalsIgnoreCase("RADIAN") || unitString.equalsIgnoreCase("RADIANS") || unitString.equalsIgnoreCase("TILT")) {
            return UnitImpl.RADIAN;
        }
        if (unitString.equalsIgnoreCase("MICRORADIANS")) {
            return UnitImpl.multiply(1.0E-6, UnitImpl.RADIAN, "MICRORADIAN");
        }
        if (unitString.equalsIgnoreCase("RAD/S")) {
            return UnitImpl.RADIAN_PER_SECOND;
        }
        if (unitString.equalsIgnoreCase("MM/HOUR")) {
            return UnitImpl.divide(UnitImpl.MILLIMETER, UnitImpl.HOUR);
        }
        if (unitString.equalsIgnoreCase("D") || unitString.equalsIgnoreCase("DEGREES")) {
            return UnitImpl.DEGREE;
        }
        if (unitString.equalsIgnoreCase("DEGC")) {
            return UnitImpl.CELSIUS;
        }
        if (unitString.equalsIgnoreCase("COUNTS") || unitString.equalsIgnoreCase("COUNT_UNIT")) {
            return UnitImpl.COUNT;
        }
        if (unitString.equalsIgnoreCase("REBOOTS") || unitString.equalsIgnoreCase("CYCLES") || unitString.equalsIgnoreCase("ERROR") || unitString.equalsIgnoreCase("BYTES") || unitString.equalsIgnoreCase("GAPS")) {
            return UnitImpl.COUNT;
        }
        if (unitString.equalsIgnoreCase("B") && unitDescription.trim().equalsIgnoreCase("boolean")) {
            return UnitImpl.DIMENSONLESS;
        }
        if (unitString.equalsIgnoreCase("1") || unitString.equalsIgnoreCase("M/M") || unitString.equalsIgnoreCase("NULL")) {
            return UnitImpl.divide(UnitImpl.METER, UnitImpl.METER);
        }
        if (unitString.equalsIgnoreCase("M**3/M**3")) {
            return UnitImpl.CUBIC_METER_PER_CUBIC_METER;
        }
        if (unitString.equalsIgnoreCase("BITS/SEC")) {
            return UnitImpl.divide(UnitImpl.COUNT, UnitImpl.SECOND);
        }
        if (unitString.equalsIgnoreCase("C/S")) {
            return UnitImpl.divide(UnitImpl.COULOMB, UnitImpl.SECOND);
        }
        try {
            return UnitImpl.getUnitFromString(unitString);
        }
        catch (NoSuchFieldException e) {
            throw new UnknownUnit("Unknown unit: '" + unitString + "' described as " + unitDescription);
        }
    }

    public static Instant convertTime(String xml) {
        return TimeUtils.parseISOString((String)xml);
    }

    public static Instant convertTime(String xml, String defaultTime) {
        String s = xml;
        if (xml == null) {
            s = defaultTime;
        }
        return TimeUtils.parseISOString((String)s);
    }

    public static String makeNoNull(String s) {
        if (s == null) {
            return UNKNOWN;
        }
        return s;
    }
}

