/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.util.convert.sac;

import edu.sc.seis.seisFile.fdsnws.stationxml.Pole;
import edu.sc.seis.seisFile.fdsnws.stationxml.PolesZeros;
import edu.sc.seis.seisFile.fdsnws.stationxml.Response;
import edu.sc.seis.seisFile.fdsnws.stationxml.ResponseStage;
import edu.sc.seis.seisFile.fdsnws.stationxml.Zero;
import edu.sc.seis.seisFile.sac.Complex;
import edu.sc.seis.seisFile.sac.SacPoleZero;
import edu.sc.seis.sod.model.common.QuantityImpl;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.common.UnknownUnit;
import edu.sc.seis.sod.util.convert.stationxml.StationXMLToFissures;

public class StationXMLToSacPoleZero {
    private static Complex ONE = new Complex(1.0, 0.0);

    public static SacPoleZero convert(Response response) throws UnknownUnit {
        ResponseStage first = response.getFirstStage();
        if (!(first.getResponseItem() instanceof PolesZeros)) {
            throw new IllegalArgumentException("First Stage is not PolesZeros: " + first.getResponseItem().getClass().getSimpleName());
        }
        PolesZeros polesZeros = (PolesZeros)first.getResponseItem();
        int gamma = 0;
        UnitImpl unit = StationXMLToFissures.convertUnit(polesZeros.getInputUnits());
        QuantityImpl scaleUnit = new QuantityImpl(1.0, unit);
        if (unit.isConvertableTo(UnitImpl.METER)) {
            gamma = 0;
            scaleUnit = scaleUnit.convertTo(UnitImpl.METER);
        } else if (unit.isConvertableTo(UnitImpl.METER_PER_SECOND)) {
            gamma = 1;
            scaleUnit = scaleUnit.convertTo(UnitImpl.METER_PER_SECOND);
        } else if (unit.isConvertableTo(UnitImpl.METER_PER_SECOND_PER_SECOND)) {
            gamma = 2;
            scaleUnit = scaleUnit.convertTo(UnitImpl.METER_PER_SECOND_PER_SECOND);
        } else {
            throw new IllegalArgumentException("response unit is not displacement, velocity or acceleration: " + String.valueOf(unit));
        }
        int num_zeros = polesZeros.getZeroList().size() + gamma;
        double mulFactor = 1.0;
        if (polesZeros.getPzTransferType().equals("LAPLACE (HERTZ)")) {
            mulFactor = Math.PI * 2;
        }
        Complex[] zeros = SacPoleZero.initCmplx((int)num_zeros);
        for (int i = 0; i < polesZeros.getZeroList().size(); ++i) {
            zeros[i] = new Complex(((Zero)polesZeros.getZeroList().get(i)).getReal() * mulFactor, ((Zero)polesZeros.getZeroList().get(i)).getImaginary() * mulFactor);
        }
        Complex[] poles = SacPoleZero.initCmplx((int)polesZeros.getPoleList().size());
        for (int i = 0; i < poles.length; ++i) {
            poles[i] = new Complex(((Pole)polesZeros.getPoleList().get(i)).getReal() * mulFactor, ((Pole)polesZeros.getPoleList().get(i)).getImaginary() * mulFactor);
        }
        float constant = polesZeros.getNormalizationFactor();
        double sd = response.getInstrumentSensitivity().getSensitivityValue();
        double fs = response.getInstrumentSensitivity().getFrequency();
        sd *= Math.pow(Math.PI * 2 * fs, gamma);
        double A0 = polesZeros.getNormalizationFactor();
        double fn = polesZeros.getNormalizationFreq();
        A0 /= Math.pow(Math.PI * 2 * fn, gamma);
        if (polesZeros.getPzTransferType().equals("LAPLACE (HERTZ)")) {
            A0 *= Math.pow(Math.PI * 2, polesZeros.getPoleList().size() - polesZeros.getZeroList().size());
        }
        constant = poles.length == 0 && zeros.length == 0 ? (float)(sd * A0) : (float)(sd * StationXMLToSacPoleZero.calc_A0(poles, zeros, fs));
        constant = (float)((double)constant * scaleUnit.getValue());
        return new SacPoleZero(poles, zeros, constant);
    }

    private static double calc_A0(Complex[] poles, Complex[] zeros, double ref_freq) {
        int i;
        Complex numer = ONE;
        Complex denom = ONE;
        Complex f0 = new Complex(0.0, Math.PI * 2 * ref_freq);
        for (i = 0; i < zeros.length; ++i) {
            denom = Complex.mul((Complex)denom, (Complex)Complex.sub((Complex)f0, (Complex)zeros[i]));
        }
        for (i = 0; i < poles.length; ++i) {
            numer = Complex.mul((Complex)numer, (Complex)Complex.sub((Complex)f0, (Complex)poles[i]));
        }
        double a0 = Complex.div((Complex)numer, (Complex)denom).mag();
        return a0;
    }
}

