/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.util.convert.sac;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.quakeml.Event;
import edu.sc.seis.seisFile.fdsnws.quakeml.Origin;
import edu.sc.seis.seisFile.fdsnws.quakeml.RealQuantity;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.seisFile.sac.SacConstants;
import edu.sc.seis.seisFile.sac.SacHeader;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import edu.sc.seis.sod.model.common.FissuresException;
import edu.sc.seis.sod.model.common.Location;
import edu.sc.seis.sod.model.common.Orientation;
import edu.sc.seis.sod.model.common.QuantityImpl;
import edu.sc.seis.sod.model.common.SamplingImpl;
import edu.sc.seis.sod.model.common.TimeRange;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.event.EventAttrImpl;
import edu.sc.seis.sod.model.event.OriginImpl;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.SeismogramAttrImpl;
import edu.sc.seis.sod.model.seismogram.TimeSeriesDataSel;
import edu.sc.seis.sod.model.station.ChannelId;
import edu.sc.seis.sod.model.station.StationId;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.Month;
import java.time.ZonedDateTime;

public class SacToFissures {
    public static LocalSeismogramImpl getSeismogram(File sacFile) throws FileNotFoundException, IOException, FissuresException {
        SacTimeSeries sac = SacTimeSeries.read((File)sacFile);
        return SacToFissures.getSeismogram(sac);
    }

    public static LocalSeismogramImpl getSeismogram(InputStream in) throws IOException, FissuresException {
        DataInputStream dis = in instanceof DataInputStream ? (DataInputStream)in : new DataInputStream(in);
        SacTimeSeries sac = SacTimeSeries.read((DataInput)dis);
        return SacToFissures.getSeismogram(sac);
    }

    public static LocalSeismogramImpl getSeismogram(SacTimeSeries sac, SeismogramAttrImpl attr) throws FissuresException {
        double error;
        LocalSeismogramImpl seis = new LocalSeismogramImpl(attr, sac.getY());
        if (seis.getNumPoints() != sac.getHeader().getNpts()) {
            seis.num_points = sac.getHeader().getNpts();
        }
        SamplingImpl samp = seis.getSampling();
        Duration period = samp.getPeriod();
        if (sac.getHeader().getDelta() != 0.0f && (error = ((double)period.toNanos() / 1.0E9 - (double)sac.getHeader().getDelta()) / (double)sac.getHeader().getDelta()) > 0.01) {
            seis.sampling_info = new SamplingImpl(1, new QuantityImpl(sac.getHeader().getDelta(), UnitImpl.SECOND).toDuration());
        }
        if (!SacConstants.isUndef((float)sac.getHeader().getB())) {
            Instant beginTime = SacToFissures.getSeismogramBeginTime(sac);
            double error2 = (double)Duration.between(seis.getBeginTime(), beginTime).toNanos() / (double)period.toNanos();
            if (Math.abs(error2) > 0.01) {
                seis.begin_time = beginTime;
            }
        }
        return seis;
    }

    public static LocalSeismogramImpl getSeismogram(SacTimeSeries sac) throws FissuresException {
        TimeSeriesDataSel data = new TimeSeriesDataSel();
        data.flt_values(sac.getY());
        return new LocalSeismogramImpl(SacToFissures.getSeismogramAttr(sac), data);
    }

    public static SeismogramAttrImpl getSeismogramAttr(SacTimeSeries sac) throws FissuresException {
        DecimalFormat df;
        Instant beginTime = SacToFissures.getSeismogramBeginTime(sac);
        ChannelId chanId = SacToFissures.getChannelId(sac);
        Object evtName = "   ";
        SacHeader header = sac.getHeader();
        if (!SacConstants.isUndef((String)header.getKevnm())) {
            evtName = (String)evtName + header.getKevnm().trim() + " ";
        }
        if (!(SacConstants.isUndef((float)header.getEvla()) || SacConstants.isUndef((float)header.getEvlo()) || SacConstants.isUndef((float)header.getEvdp()))) {
            evtName = (String)evtName + "lat: " + header.getEvla() + " lon: " + header.getEvlo() + " depth: " + header.getEvdp() / 1000.0f + " km";
        }
        if (!SacConstants.isUndef((float)sac.getHeader().getGcarc())) {
            df = new DecimalFormat("##0.#");
            evtName = (String)evtName + "  " + df.format(header.getGcarc()) + " deg.";
        }
        if (!SacConstants.isUndef((float)sac.getHeader().getAz())) {
            df = new DecimalFormat("##0.#");
            evtName = (String)evtName + "  az " + df.format(header.getAz()) + " deg.";
        }
        String seisId = chanId.getNetworkId() + ":" + chanId.getStationCode() + ":" + chanId.getLocCode() + ":" + chanId.getChannelCode() + ":" + TimeUtils.toISOString((Instant)beginTime);
        return new SeismogramAttrImpl(seisId, beginTime, sac.getHeader().getNpts(), new SamplingImpl(1, new QuantityImpl(sac.getHeader().getDelta(), UnitImpl.SECOND).toDuration()), UnitImpl.COUNT, chanId);
    }

    public static ChannelId getChannelId(SacTimeSeries sac) {
        return SacToFissures.getChannelId(sac.getHeader());
    }

    public static ChannelId getChannelId(SacHeader header) {
        if (!SacConstants.isUndef((String)header.getKhole()) && header.getKhole().trim().length() == 2) {
            return SacToFissures.getChannelId(header, header.getKhole().trim());
        }
        return SacToFissures.getChannelId(header, "  ");
    }

    public static ChannelId getChannelId(SacTimeSeries sac, String siteCode) {
        return SacToFissures.getChannelId(sac.getHeader(), siteCode);
    }

    public static ChannelId getChannelId(SacHeader header, String siteCode) {
        Instant nzTime = SacToFissures.getNZTime(header);
        String netCode = "XX";
        if (!SacConstants.isUndef((String)header.getKnetwk())) {
            netCode = header.getKnetwk().trim().toUpperCase();
        }
        String staCode = "XXXXX";
        if (!SacConstants.isUndef((String)header.getKstnm())) {
            staCode = header.getKstnm().trim().toUpperCase();
        }
        String chanCode = "XXX";
        if (!SacConstants.isUndef((String)header.getKcmpnm()) && (chanCode = header.getKcmpnm().trim().toUpperCase()).length() == 5) {
            siteCode = Channel.fixLocCode((String)chanCode.substring(0, 2));
            chanCode = chanCode.substring(2, 5);
        }
        ChannelId id = new ChannelId(netCode, staCode, siteCode, chanCode, nzTime);
        return id;
    }

    public static Channel getChannel(SacTimeSeries sac) {
        return SacToFissures.getChannel(sac.getHeader());
    }

    public static Channel getChannel(SacHeader header) {
        float stdp;
        ChannelId chanId = SacToFissures.getChannelId(header);
        float stel = header.getStel();
        if (stel == -12345.0f) {
            stel = 0.0f;
        }
        if ((stdp = header.getStdp()) == -12345.0f) {
            stdp = 0.0f;
        }
        Location loc = new Location(header.getStla(), header.getStlo(), new QuantityImpl(header.getStel(), UnitImpl.METER), new QuantityImpl(header.getStdp(), UnitImpl.METER));
        Orientation orient = new Orientation(header.getCmpaz(), header.getCmpinc() - 90.0f);
        SamplingImpl samp = new SamplingImpl(1, new QuantityImpl(header.getDelta(), UnitImpl.SECOND).toDuration());
        Instant begin_time = SacToFissures.getNZTime(header);
        TimeRange effective = new TimeRange(begin_time, (Instant)null);
        Network netAttr = new Network(chanId.getNetworkId());
        netAttr.setStartDateTime(begin_time);
        StationId staId = new StationId(chanId.getNetworkId(), chanId.getStationCode(), begin_time);
        Station station = new Station(netAttr, chanId.getStationCode());
        station.setLatitude(loc.latitude);
        station.setLongitude(loc.longitude);
        station.setElevation((float)loc.elevation.getValue(UnitImpl.METER));
        station.setStartDateTime(begin_time);
        station.setDescription("from sac");
        Channel chan = new Channel(station, chanId.getLocCode(), chanId.getChannelCode());
        chan.setAzimuth(orient.azimuth);
        chan.setDip(orient.dip);
        chan.setSampleRate((float)samp.getFrequency().getValue(UnitImpl.HERTZ));
        chan.setStartDateTime(begin_time);
        return chan;
    }

    public static Instant getNZTime(SacTimeSeries sac) {
        return SacToFissures.getNZTime(sac.getHeader());
    }

    public static Instant getNZTime(SacHeader header) {
        if (SacConstants.isUndef((int)header.getNzyear()) || SacConstants.isUndef((int)header.getNzjday()) || SacConstants.isUndef((int)header.getNzhour()) || SacConstants.isUndef((int)header.getNzmin()) || SacConstants.isUndef((int)header.getNzsec()) || SacConstants.isUndef((int)header.getNzmsec())) {
            return TimeUtils.future;
        }
        ZonedDateTime originTime = ZonedDateTime.of(header.getNzyear(), Month.JANUARY.getValue(), 1, header.getNzhour(), header.getNzmin(), header.getNzsec(), header.getNzmsec() * 1000000, TimeUtils.TZ_UTC);
        originTime = originTime.plusDays(header.getNzjday() - 1);
        return originTime.toInstant();
    }

    public static Instant getEventOriginTime(SacTimeSeries sac) {
        return SacToFissures.getEventOriginTime(sac.getHeader());
    }

    public static Instant getEventOriginTime(SacHeader header) {
        Instant originTime = SacToFissures.getNZTime(header);
        originTime = originTime.plusNanos(Math.round(1.0E9 * (double)header.getO()));
        return originTime;
    }

    public static Instant getSeismogramBeginTime(SacTimeSeries sac) {
        return SacToFissures.getSeismogramBeginTime(sac.getHeader());
    }

    public static Instant getSeismogramBeginTime(SacHeader header) {
        Instant bTime = SacToFissures.getNZTime(header);
        Duration sacBMarker = TimeUtils.durationFromSeconds((double)header.getB());
        bTime = bTime.plus(sacBMarker);
        return bTime;
    }

    public static Event getEvent(SacTimeSeries sac) {
        return SacToFissures.getEvent(sac.getHeader());
    }

    public static Event getEvent(SacHeader header) {
        if (!(SacConstants.isUndef((float)header.getO()) || SacConstants.isUndef((float)header.getEvla()) || SacConstants.isUndef((float)header.getEvlo()) || SacConstants.isUndef((float)header.getEvdp()))) {
            Instant beginTime = SacToFissures.getEventOriginTime(header);
            EventAttrImpl attr = new EventAttrImpl("SAC Event");
            OriginImpl[] origins = new OriginImpl[1];
            if (header.getEvdp() > 1000.0f) {
                Location loc = new Location(header.getEvla(), header.getEvlo(), new QuantityImpl(0.0, UnitImpl.METER), new QuantityImpl(header.getEvdp(), UnitImpl.METER));
            } else {
                Location loc = new Location(header.getEvla(), header.getEvlo(), new QuantityImpl(0.0, UnitImpl.METER), new QuantityImpl(header.getEvdp(), UnitImpl.KILOMETER));
            }
            Origin origin = new Origin(beginTime, header.getEvla(), header.getEvlo());
            if (header.getEvdp() > 1000.0f) {
                origin.setDepth(new RealQuantity(header.getEvdp() * 1000.0f));
            } else {
                origin.setDepth(new RealQuantity(header.getEvdp()));
            }
            Event event = new Event(origin);
            return event;
        }
        return null;
    }
}

