/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.util.convert.sac;

import edu.iris.dmc.seedcodec.CodecException;
import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.sac.Complex;
import edu.sc.seis.seisFile.sac.SacHeader;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import edu.sc.seis.sod.model.common.DistAz;
import edu.sc.seis.sod.model.common.FissuresException;
import edu.sc.seis.sod.model.common.QuantityImpl;
import edu.sc.seis.sod.model.common.SamplingImpl;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.event.OriginImpl;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;

public class FissuresToSac {
    private static Complex ONE = new Complex(1.0, 0.0);

    public static SacTimeSeries getSAC(LocalSeismogramImpl seis) throws CodecException {
        float[] floatSamps;
        try {
            if (seis.can_convert_to_long()) {
                int[] idata = seis.get_as_longs();
                floatSamps = new float[idata.length];
                for (int i = 0; i < idata.length; ++i) {
                    floatSamps[i] = idata[i];
                }
            } else {
                floatSamps = seis.get_as_floats();
            }
        }
        catch (FissuresException e) {
            if (e.getCause() instanceof CodecException) {
                throw (CodecException)e.getCause();
            }
            throw new CodecException((Exception)e);
        }
        SacHeader header = SacHeader.createEmptyEvenSampledTimeSeriesHeader();
        header.setIztype(9);
        SamplingImpl samp = seis.sampling_info;
        Duration period = samp.getPeriod();
        float f = (float)TimeUtils.durationToDoubleSeconds((Duration)period);
        header.setDelta(f);
        UnitImpl yUnit = seis.y_unit;
        QuantityImpl min = seis.getMinValue();
        header.setDepmin((float)min.convertTo(yUnit).getValue());
        QuantityImpl max = seis.getMaxValue();
        header.setDepmax((float)max.convertTo(yUnit).getValue());
        QuantityImpl mean = seis.getMeanValue();
        header.setDepmen((float)mean.convertTo(yUnit).getValue());
        FissuresToSac.setKZTime(header, seis.begin_time);
        header.setKnetwk(seis.channel_id.getNetworkId());
        header.setKstnm(seis.channel_id.getStationCode());
        header.setKcmpnm(seis.channel_id.getChannelCode());
        header.setKhole(seis.channel_id.getLocCode());
        return new SacTimeSeries(header, floatSamps);
    }

    public static SacTimeSeries getSAC(LocalSeismogramImpl seis, Channel channel) throws CodecException {
        SacTimeSeries sac = FissuresToSac.getSAC(seis);
        FissuresToSac.addChannel(sac.getHeader(), channel);
        return sac;
    }

    public static SacTimeSeries getSAC(LocalSeismogramImpl seis, OriginImpl origin) throws CodecException {
        SacTimeSeries sac = FissuresToSac.getSAC(seis);
        FissuresToSac.addOrigin(sac.getHeader(), origin);
        return sac;
    }

    public static SacTimeSeries getSAC(LocalSeismogramImpl seis, Channel channel, OriginImpl origin) throws CodecException {
        SacTimeSeries sac = FissuresToSac.getSAC(seis);
        if (channel != null) {
            FissuresToSac.addChannel(sac.getHeader(), channel);
        }
        if (origin != null) {
            FissuresToSac.addOrigin(sac.getHeader(), origin);
        }
        if (origin != null && channel != null) {
            DistAz distAz = new DistAz(channel, origin);
            sac.getHeader().setGcarc((float)distAz.getDelta());
            sac.getHeader().setDist((float)distAz.getDelta() * 111.19f);
            sac.getHeader().setAz((float)distAz.getAz());
            sac.getHeader().setBaz((float)distAz.getBaz());
        }
        return sac;
    }

    public static void addChannel(SacHeader header, Channel channel) {
        header.setStla(channel.getLatitude().getValue());
        header.setStlo(channel.getLongitude().getValue());
        header.setStel(channel.getElevation().getValue());
        header.setStdp(channel.getDepth().getValue());
        header.setCmpaz(channel.getAzimuth().getValue());
        header.setCmpinc(90.0f + channel.getDip().getValue());
    }

    public static void addOrigin(SacHeader header, OriginImpl origin) {
        header.setEvla(origin.getLocation().latitude);
        header.setEvlo(origin.getLocation().longitude);
        QuantityImpl z = origin.getLocation().elevation;
        header.setEvel((float)z.convertTo(UnitImpl.METER).getValue());
        z = origin.getLocation().depth;
        header.setEvdp((float)z.convertTo(UnitImpl.METER).getValue());
        ZonedDateTime isoTime = ZonedDateTime.of(header.getNzyear(), 1, 1, header.getNzhour(), header.getNzmin(), header.getNzsec(), header.getNzmsec() * 1000000, TimeUtils.TZ_UTC);
        isoTime = isoTime.plusDays(header.getNzjday() - 1);
        Instant beginTime = isoTime.toInstant();
        Instant originTime = origin.getOriginTime();
        FissuresToSac.setKZTime(header, originTime);
        Duration sacBMarker = Duration.between(originTime, beginTime);
        header.setB((float)TimeUtils.durationToDoubleSeconds((Duration)sacBMarker));
        header.setO(0.0f);
        header.setIztype(11);
        if (origin.getMagnitudes().length > 0) {
            header.setMag(origin.getMagnitudes()[0].value);
        }
    }

    public static void setKZTime(SacHeader header, Instant date) {
        ZonedDateTime zdt = ZonedDateTime.ofInstant(date, TimeUtils.TZ_UTC);
        header.setNzyear(zdt.getYear());
        header.setNzjday(zdt.getDayOfYear());
        header.setNzhour(zdt.getHour());
        header.setNzmin(zdt.getMinute());
        header.setNzsec(zdt.getSecond());
        header.setNzmsec(zdt.getNano() / 1000000);
    }
}

