/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.util.convert.mseed;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.mseed.Blockette;
import edu.sc.seis.seisFile.mseed.Blockette100;
import edu.sc.seis.seisFile.mseed.Blockette1000;
import edu.sc.seis.seisFile.mseed.Btime;
import edu.sc.seis.seisFile.mseed.BtimeRange;
import edu.sc.seis.seisFile.mseed.DataHeader;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.SeedRecord;
import edu.sc.seis.sod.model.common.FissuresException;
import edu.sc.seis.sod.model.common.ParameterRef;
import edu.sc.seis.sod.model.common.QuantityImpl;
import edu.sc.seis.sod.model.common.SamplingImpl;
import edu.sc.seis.sod.model.common.TimeRange;
import edu.sc.seis.sod.model.common.UnitBase;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.seismogram.EncodedData;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.Plottable;
import edu.sc.seis.sod.model.seismogram.PlottableChunk;
import edu.sc.seis.sod.model.seismogram.Property;
import edu.sc.seis.sod.model.seismogram.TimeSeriesDataSel;
import edu.sc.seis.sod.model.seismogram.TimeSeriesType;
import edu.sc.seis.sod.model.station.ChannelId;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import edu.sc.seis.sod.model.station.NetworkIdUtil;
import edu.sc.seis.sod.util.display.IntRange;
import edu.sc.seis.sod.util.display.SimplePlotUtil;
import edu.sc.seis.sod.util.time.RangeTool;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FissuresConvert {
    public static final byte RECORD_SIZE_4096_POWER = 12;
    public static int RECORD_SIZE_4096 = (int)Math.pow(2.0, 12.0);
    public static final byte RECORD_SIZE_1024_POWER = 10;
    public static int RECORD_SIZE_1024 = (int)Math.pow(2.0, 10.0);
    public static final byte RECORD_SIZE_512_POWER = 9;
    public static int RECORD_SIZE_512 = (int)Math.pow(2.0, 9.0);
    public static final byte RECORD_SIZE_256_POWER = 8;
    public static int RECORD_SIZE_256 = (int)Math.pow(2.0, 8.0);
    public static final Duration DAY = Duration.ofDays(1L);
    private static final Logger logger = LoggerFactory.getLogger(FissuresConvert.class);

    private FissuresConvert() {
    }

    public static DataRecord[] toMSeed(LocalSeismogramImpl seis) throws SeedFormatException {
        return FissuresConvert.toMSeed(seis, 1);
    }

    public static DataRecord[] toMSeed(LocalSeismogramImpl seis, int seqStart) throws SeedFormatException {
        LinkedList<Object> outRecords = new LinkedList();
        Instant start = seis.begin_time;
        if (seis.data.discriminator().equals(TimeSeriesType.TYPE_ENCODED)) {
            EncodedData[] eData = seis.data.encoded_values();
            outRecords = FissuresConvert.toMSeed(eData, seis.channel_id, start, seis.sampling_info, seqStart);
        } else if (seis.data.discriminator().equals(TimeSeriesType.TYPE_LONG)) {
            try {
                outRecords = FissuresConvert.toMSeed(FissuresConvert.toEncodedData(seis.get_as_longs()), seis.channel_id, start, seis.sampling_info, seqStart);
            }
            catch (FissuresException e) {
                throw new SeedFormatException("Problem getting integer data", (Throwable)e);
            }
        } else if (seis.data.discriminator().equals(TimeSeriesType.TYPE_FLOAT)) {
            try {
                EncodedData[] eData = new EncodedData[(int)Math.ceil((float)seis.num_points * 4.0f / 3968.0f)];
                float[] data = seis.get_as_floats();
                for (int i = 0; i < eData.length; ++i) {
                    int j;
                    byte[] dataBytes = new byte[3968];
                    for (j = 0; j + 992 * i < data.length && j < 992; ++j) {
                        int val = Float.floatToIntBits(data[j + 992 * i]);
                        dataBytes[4 * j] = (byte)((val & 0xFF000000) >> 24);
                        dataBytes[4 * j + 1] = (byte)((val & 0xFF0000) >> 16);
                        dataBytes[4 * j + 2] = (byte)((val & 0xFF00) >> 8);
                        dataBytes[4 * j + 3] = (byte)(val & 0xFF);
                    }
                    if (j == 0) {
                        throw new SeedFormatException("try to put 0 float samples into an encodedData object j=" + j + " i=" + i + " seis.num_ppoints=" + seis.num_points);
                    }
                    eData[i] = new EncodedData(4, dataBytes, j, false);
                }
                outRecords = FissuresConvert.toMSeed(eData, seis.channel_id, start, seis.sampling_info, seqStart);
            }
            catch (FissuresException e) {
                throw new SeedFormatException("Problem getting float data", (Throwable)e);
            }
        } else if (seis.data.discriminator().equals(TimeSeriesType.TYPE_LONG)) {
            try {
                EncodedData[] eData = new EncodedData[(int)Math.ceil((float)seis.num_points * 4.0f / 3968.0f)];
                int[] data = seis.get_as_longs();
                for (int i = 0; i < eData.length; ++i) {
                    int j;
                    byte[] dataBytes = new byte[3968];
                    for (j = 0; j + 992 * i < data.length && j < 992; ++j) {
                        int val = data[j + 992 * i];
                        dataBytes[4 * j] = (byte)((val & 0xFF000000) >> 24);
                        dataBytes[4 * j + 1] = (byte)((val & 0xFF0000) >> 16);
                        dataBytes[4 * j + 2] = (byte)((val & 0xFF00) >> 8);
                        dataBytes[4 * j + 3] = (byte)(val & 0xFF);
                    }
                    if (j == 0) {
                        throw new SeedFormatException("try to put 0 int samples into an encodedData object j=" + j + " i=" + i + " seis.num_ppoints=" + seis.num_points);
                    }
                    eData[i] = new EncodedData(3, dataBytes, j, false);
                }
                outRecords = FissuresConvert.toMSeed(eData, seis.channel_id, start, seis.sampling_info, seqStart);
            }
            catch (FissuresException e) {
                throw new SeedFormatException("Problem getting float data", (Throwable)e);
            }
        } else {
            throw new SeedFormatException("Can only handle EncodedData now, type=" + seis.data.discriminator().value());
        }
        return outRecords.toArray(new DataRecord[0]);
    }

    public static LinkedList<DataRecord> toMSeed(EncodedData[] eData, ChannelId channel_id, Instant start, SamplingImpl sampling_info, int seqStart) throws SeedFormatException {
        return FissuresConvert.toMSeed(eData, channel_id, start, sampling_info, seqStart, 'M');
    }

    public static LinkedList<DataRecord> toMSeed(EncodedData[] eData, ChannelId channel_id, Instant start, SamplingImpl sampling_info, int seqStart, char typeCode) throws SeedFormatException {
        Blockette100 b100;
        Blockette1000 b1000;
        DataHeader header;
        int i;
        LinkedList<DataRecord> list = new LinkedList<DataRecord>();
        int recordSize = RECORD_SIZE_4096;
        int recordSizePower = 12;
        int minRecordSize = 0;
        for (i = 0; i < eData.length; ++i) {
            header = new DataHeader(seqStart++, typeCode, false);
            b1000 = new Blockette1000();
            b100 = new Blockette100();
            if (minRecordSize >= eData[i].values.length + header.getSize() + b1000.getSize()) continue;
            minRecordSize = eData[i].values.length + header.getSize() + b1000.getSize();
        }
        if (minRecordSize < RECORD_SIZE_4096) {
            recordSize = RECORD_SIZE_4096;
            recordSizePower = 12;
        }
        if (minRecordSize < RECORD_SIZE_1024) {
            recordSize = RECORD_SIZE_1024;
            recordSizePower = 10;
        }
        if (minRecordSize < RECORD_SIZE_512) {
            recordSize = RECORD_SIZE_512;
            recordSizePower = 9;
        }
        for (i = 0; i < eData.length; ++i) {
            header = new DataHeader(seqStart++, 'D', false);
            b1000 = new Blockette1000();
            b100 = new Blockette100();
            if (eData[i].values.length + header.getSize() + b1000.getSize() + b100.getSize() >= recordSize) {
                if (eData[i].values.length + header.getSize() + b1000.getSize() < recordSize) {
                    b100 = null;
                } else {
                    throw new SeedFormatException("Can't fit data into record of size " + recordSize + " " + (eData[i].values.length + header.getSize() + b1000.getSize() + b100.getSize()) + " " + eData[i].values.length + " " + (header.getSize() + b1000.getSize() + b100.getSize()));
                }
            }
            header.setStationIdentifier(channel_id.getStationCode());
            header.setLocationIdentifier(channel_id.getLocCode());
            header.setChannelIdentifier(channel_id.getChannelCode());
            header.setNetworkCode(channel_id.getNetworkId());
            header.setStartBtime(FissuresConvert.getBtime(start));
            header.setNumSamples((short)eData[i].num_points);
            Duration sampPeriod = sampling_info.getPeriod();
            start = start.plus(sampPeriod.multipliedBy(eData[i].num_points));
            short[] multiAndFactor = FissuresConvert.calcSeedMultipilerFactor(sampling_info);
            header.setSampleRateFactor(multiAndFactor[0]);
            header.setSampleRateMultiplier(multiAndFactor[1]);
            b1000.setEncodingFormat((byte)eData[i].compression);
            if (eData[i].byte_order) {
                b1000.setWordOrder((byte)0);
            } else {
                b1000.setWordOrder((byte)1);
            }
            b1000.setDataRecordLength((byte)recordSizePower);
            DataRecord dr = new DataRecord(header);
            dr.addBlockette((Blockette)b1000);
            QuantityImpl hertz = sampling_info.getFrequency().convertTo(UnitImpl.HERTZ);
            if (b100 != null) {
                b100.setActualSampleRate((float)hertz.getValue());
                dr.addBlockette((Blockette)b100);
            }
            dr.setData(eData[i].values);
            list.add(dr);
        }
        return list;
    }

    public static short[] calcSeedMultipilerFactor(SamplingImpl sampling) {
        double sps = sampling.getFrequency().getValue(UnitImpl.HERTZ);
        return DataHeader.calcSeedMultipilerFactor((double)sps);
    }

    public static LocalSeismogramImpl toFissures(String filename) throws SeedFormatException, IOException, FissuresException {
        ArrayList<DataRecord> data = new ArrayList<DataRecord>();
        DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(filename)));
        try {
            while (true) {
                SeedRecord sr;
                if (!((sr = SeedRecord.read((DataInput)dis, (int)4096)) instanceof DataRecord)) {
                    continue;
                }
                data.add((DataRecord)sr);
            }
        }
        catch (EOFException eOFException) {
            return FissuresConvert.toFissures(data.toArray(new DataRecord[0]));
        }
    }

    public static List<LocalSeismogramImpl> toFissures(List<DataRecord> seed) throws SeedFormatException, FissuresException {
        ArrayList<LocalSeismogramImpl> out = new ArrayList<LocalSeismogramImpl>();
        ArrayList<DataRecord> contiguous = new ArrayList<DataRecord>();
        DataRecord prev = null;
        for (DataRecord dr : seed) {
            if (prev != null && !RangeTool.areContiguous(FissuresConvert.getTimeRange(prev.getBtimeRange()), FissuresConvert.getTimeRange(dr.getBtimeRange()), FissuresConvert.convertSampleRate(prev).getPeriod())) {
                LocalSeismogramImpl seis = FissuresConvert.toFissuresSeismogram(contiguous);
                out.add(seis);
                contiguous.clear();
            }
            contiguous.add(dr);
            prev = dr;
        }
        if (contiguous.size() != 0) {
            LocalSeismogramImpl seis = FissuresConvert.toFissuresSeismogram(contiguous);
            out.add(seis);
        }
        return out;
    }

    public static LocalSeismogramImpl toFissuresSeismogram(List<DataRecord> seed) throws SeedFormatException, FissuresException {
        LocalSeismogramImpl seis = null;
        for (DataRecord dataRecord : seed) {
            if (seis == null) {
                seis = FissuresConvert.toFissures(dataRecord);
                continue;
            }
            FissuresConvert.append(seis, dataRecord);
        }
        return seis;
    }

    public static LocalSeismogramImpl toFissures(DataRecord[] seed) throws SeedFormatException, FissuresException {
        LocalSeismogramImpl seis = FissuresConvert.toFissures(seed[0]);
        for (int i = 1; i < seed.length; ++i) {
            FissuresConvert.append(seis, seed[i]);
        }
        return seis;
    }

    public static LocalSeismogramImpl toFissures(DataRecord[] seed, byte defaultCompression, byte defaultByteOrder) throws SeedFormatException, FissuresException {
        DataRecord[] seedCopy = new DataRecord[seed.length];
        for (int i = 0; i < seed.length; ++i) {
            if (seed[i].getBlockettes(1000).length == 0) {
                seedCopy[i] = new DataRecord(seed[i]);
                Blockette1000 fakeB1000 = new Blockette1000();
                fakeB1000.setEncodingFormat(defaultCompression);
                fakeB1000.setWordOrder(defaultByteOrder);
                fakeB1000.setDataRecordLength((byte)30);
                seedCopy[i].setRecordSize(seed[i].getRecordSize() * 2);
                seedCopy[i].addBlockette((Blockette)fakeB1000);
                continue;
            }
            seedCopy[i] = seed[i];
        }
        return FissuresConvert.toFissures(seedCopy);
    }

    public static LocalSeismogramImpl append(LocalSeismogramImpl seis, DataRecord[] seed) throws SeedFormatException, FissuresException {
        for (int i = 0; i < seed.length; ++i) {
            FissuresConvert.append(seis, seed[i]);
        }
        return seis;
    }

    public static LocalSeismogramImpl append(LocalSeismogramImpl seis, DataRecord seed) throws SeedFormatException, FissuresException {
        TimeSeriesDataSel bits = FissuresConvert.convertData(seed);
        EncodedData[] edata = bits.encoded_values();
        for (int j = 0; j < edata.length; ++j) {
            if (edata[j] == null) {
                throw new RuntimeException("encoded data is null " + j);
            }
            seis.append_encoded(edata[j]);
            Instant drEnd = seed.getLastSampleBtime().toInstant();
            seis.sampling_info = new SamplingImpl(seis.getNumPoints() - 1, Duration.between(seis.getBeginTime(), drEnd));
        }
        return seis;
    }

    public static LocalSeismogramImpl toFissures(DataRecord seed) throws SeedFormatException {
        DataHeader header = seed.getHeader();
        String isoTime = FissuresConvert.getISOTime(header.getStartBtime());
        Instant time = TimeUtils.parseISOString((String)isoTime);
        String netId = header.getNetworkCode();
        if (NetworkIdUtil.isTemporary(netId)) {
            netId = NetworkIdUtil.formId(netId, time);
        }
        ChannelId channelId = new ChannelId(netId, header.getStationIdentifier().trim(), Channel.fixLocCode((String)header.getLocationIdentifier()), header.getChannelIdentifier().trim(), time);
        String seisId = channelId.getNetworkId() + ":" + channelId.getStationCode() + ":" + channelId.getLocCode() + ":" + channelId.getChannelCode() + ":" + FissuresConvert.getISOTime(header.getStartBtime());
        Property[] props = new Property[]{new Property("Name", seisId)};
        SamplingImpl sampling = FissuresConvert.convertSampleRate(seed);
        TimeSeriesDataSel bits = FissuresConvert.convertData(seed);
        return new LocalSeismogramImpl(seisId, props, time, header.getNumSamples(), sampling, UnitImpl.COUNT, channelId, new ParameterRef[0], bits);
    }

    public static List<DataRecord> toMSeed(List<PlottableChunk> chunkList) throws SeedFormatException {
        ArrayList<DataRecord> out = new ArrayList<DataRecord>();
        int seqStart = 0;
        for (PlottableChunk chunk : chunkList) {
            ChannelId chan = new ChannelId(NetworkIdUtil.formId(chunk.getNetworkCode(), chunk.getBeginTime()), chunk.getStationCode(), chunk.getSiteCode(), chunk.getChannelCode(), chunk.getBeginTime());
            SamplingImpl samp = new SamplingImpl(chunk.getPixelsPerDay() * 2, DAY);
            LinkedList<DataRecord> drList = FissuresConvert.toMSeed(FissuresConvert.toEncodedData(chunk.getYData()), chan, chunk.getBeginTime().plus(samp.getPeriod().multipliedBy(chunk.getBeginPixel())), samp, seqStart);
            logger.debug("Plot toMSeed begin: " + ((DataRecord)drList.get(0)).getHeader().getStartTime());
            out.addAll(drList);
            seqStart += drList.size();
        }
        return out;
    }

    public static List<PlottableChunk> toPlottable(List<DataRecord> drList) throws SeedFormatException, FissuresException {
        ArrayList<PlottableChunk> out = new ArrayList<PlottableChunk>();
        for (DataRecord dr : drList) {
            out.add(FissuresConvert.toPlottable(dr));
        }
        return out;
    }

    public static PlottableChunk toPlottable(DataRecord dr) throws SeedFormatException, FissuresException {
        LocalSeismogramImpl seis = FissuresConvert.toFissures(new DataRecord[]{dr});
        int[] yData = seis.get_as_longs();
        int[] xData = new int[yData.length];
        for (int i = 0; i < xData.length; ++i) {
            xData[i] = i / 2;
        }
        Plottable pData = new Plottable(xData, yData);
        int pixelsPerDay = Math.round((float)DAY.toNanos() / (float)seis.getSampling().getPeriod().toNanos() / 2.0f);
        IntRange seisPixelRange = SimplePlotUtil.getDayPixelRange(seis, pixelsPerDay, seis.getBeginTime());
        PlottableChunk chunk = new PlottableChunk(pData, 0, seis.getBeginTime(), pixelsPerDay, seis.getChannelID().getNetworkId(), seis.getChannelID().getStationCode(), seis.getChannelID().getLocCode(), seis.getChannelID().getChannelCode());
        logger.debug("chunk " + ChannelIdUtil.toStringNoDates(seis.getChannelID()) + " " + String.valueOf(chunk.getBeginTime()) + " " + String.valueOf(chunk.getEndTime()) + " " + chunk.getBeginPixel() + " " + chunk.getNumDataPoints() + " " + chunk.getNumPixels() + " " + chunk.getPixelsPerDay());
        return chunk;
    }

    public static SamplingImpl convertSampleRate(DataRecord seed) {
        SamplingImpl sampling;
        Blockette[] blocketts = seed.getBlockettes(100);
        if (blocketts.length != 0) {
            Blockette100 b100 = (Blockette100)blocketts[0];
            float f = b100.getActualSampleRate();
            int numPerSampling = 1;
            Duration timeInterval = TimeUtils.durationFromSeconds((double)f);
            sampling = new SamplingImpl(numPerSampling, timeInterval);
        } else {
            DataHeader header = seed.getHeader();
            sampling = FissuresConvert.convertSampleRate(header.getSampleRateMultiplier(), header.getSampleRateFactor());
        }
        return sampling;
    }

    public static SamplingImpl convertSampleRate(int multi, int factor) {
        Duration timeInterval;
        int numPerSampling;
        if (factor > 0) {
            numPerSampling = factor;
            timeInterval = TimeUtils.ONE_SECOND;
            if (multi > 0) {
                numPerSampling *= multi;
            } else {
                timeInterval = timeInterval.multipliedBy(-1 * multi);
            }
        } else {
            numPerSampling = 1;
            timeInterval = TimeUtils.ONE_SECOND.multipliedBy(-1 * factor);
            if (multi > 0) {
                numPerSampling *= multi;
            } else {
                timeInterval = timeInterval.multipliedBy(-1 * multi);
            }
        }
        SamplingImpl sampling = new SamplingImpl(numPerSampling, timeInterval);
        return sampling;
    }

    public static TimeSeriesDataSel convertData(DataRecord seed) throws SeedFormatException {
        Blockette1000 b1000 = (Blockette1000)seed.getUniqueBlockette(1000);
        EncodedData eData = new EncodedData(b1000.getEncodingFormat(), seed.getData(), seed.getHeader().getNumSamples(), !b1000.isBigEndian());
        EncodedData[] eArray = new EncodedData[]{eData};
        TimeSeriesDataSel bits = new TimeSeriesDataSel();
        bits.encoded_values(eArray);
        return bits;
    }

    public static EncodedData[] toEncodedData(int[] data) {
        if (data.length == 0) {
            return new EncodedData[0];
        }
        EncodedData[] eData = new EncodedData[(int)Math.ceil((float)data.length * 4.0f / 3968.0f)];
        for (int i = 0; i < eData.length; ++i) {
            int j;
            byte[] dataBytes = new byte[3968];
            for (j = 0; j + 992 * i < data.length && j < 992; ++j) {
                int val = data[j + 992 * i];
                dataBytes[4 * j] = (byte)((val & 0xFF000000) >> 24);
                dataBytes[4 * j + 1] = (byte)((val & 0xFF0000) >> 16);
                dataBytes[4 * j + 2] = (byte)((val & 0xFF00) >> 8);
                dataBytes[4 * j + 3] = (byte)(val & 0xFF);
            }
            eData[i] = new EncodedData(3, dataBytes, j, false);
        }
        return eData;
    }

    public static String getISOTime(Btime startStruct) {
        return startStruct.toInstant().toString();
    }

    public static Instant getZonedDateTime(Btime startStruct) {
        return startStruct.toInstant();
    }

    public static Btime getBtime(Instant date) {
        ZonedDateTime zdt = ZonedDateTime.ofInstant(date, TimeUtils.TZ_UTC);
        Btime btime = new Btime();
        btime.tenthMilli = zdt.getNano() / 100000;
        btime.year = zdt.getYear();
        btime.jday = zdt.getDayOfYear();
        btime.hour = zdt.getHour();
        btime.min = zdt.getMinute();
        btime.sec = zdt.getSecond();
        return btime;
    }

    public static TimeRange getTimeRange(BtimeRange bTime) {
        return new TimeRange(bTime.getBegin().toInstant(), bTime.getEnd().toInstant());
    }

    public static byte[] toBytes(UnitImpl obj) {
        ByteArrayOutputStream byteHolder = new ByteArrayOutputStream();
        try {
            ObjectOutputStream fissuresWriter = new ObjectOutputStream(byteHolder);
            fissuresWriter.writeObject(obj);
            return byteHolder.toByteArray();
        }
        catch (IOException io) {
            throw new RuntimeException("Didn't think it was possible to get an IO exception dealing entirely with in memory streams", io);
        }
    }

    public static UnitImpl fromBytes(byte[] bytes) throws IOException {
        UnitImpl impl;
        try {
            impl = (UnitImpl)new ObjectInputStream(new ByteArrayInputStream(bytes)).readObject();
        }
        catch (ClassNotFoundException cnf) {
            throw new IllegalArgumentException("The serialized bytes passed to fromBytes must contain a serialized UnitImpl, instead it was a class we couldn't find: " + cnf.getMessage());
        }
        FissuresConvert.singletonizeUnitBase(impl);
        return impl;
    }

    private static void singletonizeUnitBase(UnitImpl impl) {
        impl.the_unit_base = UnitBase.from_int(impl.the_unit_base.value());
        for (int i = 0; i < impl.elements.length; ++i) {
            FissuresConvert.singletonizeUnitBase(impl.elements[i]);
        }
    }
}

