/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.station;

import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.DOMHelper;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.model.station.StationIdUtil;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.status.Fail;
import edu.sc.seis.sod.status.Pass;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.subsetter.station.StationSubsetter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.xml.xpath.XPathException;
import org.w3c.dom.Element;

public class StationRegularExpression
implements StationSubsetter {
    private Pattern[] patterns;

    public StationRegularExpression(Element el) throws IOException, XPathException {
        if (DOMHelper.hasElement(el, "url")) {
            String url = DOMHelper.extractText(el, "url");
            this.patterns = StationRegularExpression.readPattern(url);
        } else if (DOMHelper.hasElement(el, "code")) {
            this.patterns = new Pattern[]{Pattern.compile(SodUtil.getNestedText(DOMHelper.getElement(el, "code")))};
        }
    }

    @Override
    public StringTree accept(Station station, NetworkSource network) throws Exception {
        for (int i = 0; i < this.patterns.length; ++i) {
            if (!this.patterns[i].matcher(StationIdUtil.toStringNoDates(station)).matches()) continue;
            return new Pass(this);
        }
        return new Fail(this);
    }

    public static Pattern[] readPattern(String filterURL) throws IOException {
        int curInt;
        InputStream filterStream = new URL(filterURL.trim()).openStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(filterStream));
        StringBuffer buff = new StringBuffer();
        ArrayList<Pattern> gottenPatterns = new ArrayList<Pattern>();
        while ((curInt = ((Reader)reader).read()) != -1) {
            char curChar = (char)curInt;
            if (curChar != '\n') {
                buff.append(curChar);
                continue;
            }
            gottenPatterns.add(Pattern.compile(buff.toString()));
            buff = new StringBuffer();
        }
        return gottenPatterns.toArray(new Pattern[0]);
    }
}

