/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.station;

import edu.sc.seis.seisFile.DonutArea;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.model.common.DistAz;
import edu.sc.seis.sod.model.common.Location;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.origin.AbstractOriginPoint;
import edu.sc.seis.sod.subsetter.station.StationSubsetter;
import org.w3c.dom.Element;

public class StationPointDistance
extends AbstractOriginPoint
implements StationSubsetter {
    private double min = this.getMin().convertTo(UnitImpl.DEGREE).get_value();
    private double max = this.getMax().convertTo(UnitImpl.DEGREE).get_value();

    public StationPointDistance(Element config) throws Exception {
        super(config);
    }

    @Override
    public StringTree accept(Station station, NetworkSource network) {
        Location loc = Location.of(station);
        DistAz distaz = new DistAz(this.latitude, this.longitude, loc.latitude, loc.longitude);
        return new StringTreeLeaf(this, this.min <= distaz.getDelta() && this.max >= distaz.getDelta());
    }

    public DonutArea asDonut() {
        DonutArea d = new DonutArea();
        d.latitude = (float)this.latitude;
        d.longitude = (float)this.longitude;
        d.minradius = (float)this.min;
        d.maxradius = (float)this.max;
        return d;
    }
}

