/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.station;

import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.model.common.DistAz;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.status.Fail;
import edu.sc.seis.sod.status.Pass;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.subsetter.origin.AbstractOriginPoint;
import edu.sc.seis.sod.subsetter.station.StationSubsetter;
import org.w3c.dom.Element;

public class StationPointBackAzimuth
extends AbstractOriginPoint
implements StationSubsetter {
    public StationPointBackAzimuth(Element config) throws Exception {
        super(config);
    }

    @Override
    public StringTree accept(Station station, NetworkSource network) {
        double oLat = station.getLatitude().getValue();
        double oLon = station.getLongitude().getValue();
        DistAz distaz = new DistAz(oLat, oLon, this.latitude, this.longitude);
        if (this.getMin().convertTo(UnitImpl.DEGREE).get_value() <= distaz.getBaz() && this.getMax().convertTo(UnitImpl.DEGREE).get_value() >= distaz.getBaz()) {
            return new Pass(this);
        }
        return new Fail((Object)this, "reject back azimuth " + String.valueOf(station) + " distaz=" + distaz.getBaz());
    }
}

