/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.station;

import edu.sc.seis.seisFile.fdsnws.FDSNWSException;
import edu.sc.seis.seisFile.fdsnws.IRISWSVirtualNetworkQuerier;
import edu.sc.seis.seisFile.fdsnws.IRISWSVirtualNetworkQueryParams;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.seisFile.fdsnws.virtualnet.ContributorNetwork;
import edu.sc.seis.seisFile.fdsnws.virtualnet.VirtualNetwork;
import edu.sc.seis.seisFile.fdsnws.virtualnet.VirtualNetworkList;
import edu.sc.seis.seisFile.fdsnws.virtualnet.VirtualStation;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.model.station.NetworkIdUtil;
import edu.sc.seis.sod.source.SodSourceException;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.status.Fail;
import edu.sc.seis.sod.status.Pass;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.subsetter.station.StationSubsetter;
import edu.sc.seis.sod.util.time.ClockUtil;
import java.time.Duration;
import java.time.Instant;
import org.w3c.dom.Element;

public class BelongsToVirtual
implements StationSubsetter {
    private String host = "http://service.iris.edu";
    private String path = "irisws/virtualnetwork/1/query";
    private String code;
    private VirtualNetworkList vnetList;
    private Duration refreshInterval;
    private Instant lastQuery = ClockUtil.wayPast();

    private VirtualNetworkList getVirtual(String host, String code) throws ConfigurationException, FDSNWSException {
        IRISWSVirtualNetworkQueryParams qp = new IRISWSVirtualNetworkQueryParams(host);
        qp.setCode(code);
        IRISWSVirtualNetworkQuerier querier = new IRISWSVirtualNetworkQuerier(qp);
        VirtualNetworkList vnet = querier.getVirtual();
        return vnet;
    }

    public BelongsToVirtual(Element el) throws ConfigurationException {
        this(SodUtil.getNestedText(el), null);
    }

    public BelongsToVirtual(String virtualNetCode, Duration refreshInterval) {
        this.code = virtualNetCode;
        this.refreshInterval = refreshInterval;
    }

    @Override
    public StringTree accept(Station station, NetworkSource network) throws ConfigurationException, SodSourceException {
        try {
            this.refreshStations(network);
            for (VirtualNetwork vnet : this.vnetList.getVirtualNetworks()) {
                for (ContributorNetwork cn : vnet.getContribNetList()) {
                    if (!station.getNetwork().getCode().equals(cn.getCode()) || NetworkIdUtil.isTemporary(station.getNetwork()) && !cn.getStartYear().equals(station.getNetwork().getStartYearString())) continue;
                    for (VirtualStation vsta : cn.getStationList()) {
                        if (!station.getStationCode().equals(vsta.getCode())) continue;
                        return new Pass(this);
                    }
                }
            }
            return new Fail(this);
        }
        catch (FDSNWSException e) {
            throw new SodSourceException("Problem getting virtual networks", e);
        }
    }

    private void refreshStations(NetworkSource network) throws ConfigurationException, SodSourceException, FDSNWSException {
        if (ClockUtil.now().minus(this.getRefreshInterval()).isAfter(this.lastQuery)) {
            this.lastQuery = ClockUtil.now();
            this.vnetList = this.getVirtual(this.host, this.code);
        }
    }

    public Duration getRefreshInterval() {
        if (this.refreshInterval == null) {
            this.refreshInterval = Start.getNetworkArm().getRefreshInterval();
        }
        return this.refreshInterval;
    }
}

