/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.requestGenerator;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.DOMHelper;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.event.OriginImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.subsetter.requestGenerator.RequestGenerator;
import edu.sc.seis.sod.util.display.EventUtil;
import java.time.Duration;
import java.time.Instant;
import org.w3c.dom.Element;

public class OriginOffsetRequest
implements RequestGenerator {
    private Duration beginOffset;
    private Duration endOffset;

    public OriginOffsetRequest(Element config) throws ConfigurationException {
        Element beginEl = DOMHelper.extractElement(config, "beginOffset");
        this.beginOffset = SodUtil.loadTimeInterval(beginEl);
        Element endEl = DOMHelper.extractElement(config, "endOffset");
        this.endOffset = SodUtil.loadTimeInterval(endEl);
    }

    @Override
    public RequestFilter[] generateRequest(CacheEvent event, Channel channel, MeasurementStorage cookieJar) throws Exception {
        OriginImpl origin = EventUtil.extractOrigin(event);
        Instant originDate = origin.getOriginTime();
        Instant bDate = originDate.plus(this.beginOffset);
        Instant eDate = originDate.plus(this.endOffset);
        RequestFilter[] filters = new RequestFilter[]{new RequestFilter(channel, bDate, eDate)};
        return filters;
    }
}

