/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.request;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.subsetter.request.BreqFastRequest;
import java.io.IOException;
import java.io.Writer;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import org.w3c.dom.Element;

public class NetDCRequest
extends BreqFastRequest {
    private DateTimeFormatter netDCTimeFormat = TimeUtils.createFormatter((String)"'\"'yyyy MM dd HH mm ss.SSSS'\"'");

    public NetDCRequest(Element config) throws ConfigurationException {
        super(config);
    }

    @Override
    protected void insertRequest(Channel channel, RequestFilter[] request, Writer out, int i) throws IOException {
        Instant start = request[i].startTime;
        Instant end = request[i].endTime;
        out.write(".DATA * " + channel.getNetworkCode() + " " + channel.getStationCode() + " " + channel.getLocCode() + " " + channel.getCode() + " " + this.netDCTimeFormat.format(start) + " " + this.netDCTimeFormat.format(end) + "\n");
    }

    @Override
    protected void insertEventHeader(CacheEvent event, Writer out, String label) throws IOException {
        out.write(".NETDC_REQUEST\n");
        this.insert(out, "name");
        this.insert(out, "inst");
        this.optInsert(out, "mail");
        this.insert(out, "email");
        this.optInsert(out, "phone");
        this.optInsert(out, "fax");
        out.write(".LABEL " + label + "\n");
        this.optInsert(out, "media");
        this.optInsert(out, "altmedia", "ALTERNATIVE MEDIA");
        this.optInsert(out, "format_waveform");
        this.optInsert(out, "format_response");
        this.optInsert(out, "merge_data");
        this.optInsert(out, "disposition");
        out.write(".END\n");
        out.write("\n");
    }

    @Override
    protected String getDefaultWorkingDir() {
        return "netdc";
    }

    @Override
    protected String getDefaultFileTemplate() {
        return "${event.getTime('yyyy.DDD.HH.mm.ss.SSSS')}.netdc";
    }
}

