/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.request;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.DOMHelper;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.event.OriginImpl;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.status.FissuresFormatter;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.VelocityFileElementParser;
import edu.sc.seis.sod.subsetter.request.RequestSubsetter;
import edu.sc.seis.sod.util.display.EventUtil;
import edu.sc.seis.sod.util.display.ParseRegions;
import edu.sc.seis.sod.velocity.SimpleVelocitizer;
import edu.sc.seis.sod.velocity.WaveformProcessContext;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import org.apache.velocity.VelocityContext;
import org.w3c.dom.Element;

public class BreqFastRequest
implements RequestSubsetter {
    static final String nl = "\n";
    DateTimeFormatter format = TimeUtils.createFormatter((String)"yyyy MM dd HH mm ss.");
    DateTimeFormatter tenths = TimeUtils.createFormatter((String)"SSS");
    ParseRegions regions;
    Element config;
    private String fullTemplate;
    private String labelTemplate;
    private SimpleVelocitizer velocitizer = new SimpleVelocitizer();

    public BreqFastRequest(Element config) throws ConfigurationException {
        this.config = config;
        VelocityFileElementParser parser = new VelocityFileElementParser(config, this.getDefaultWorkingDir(), this.getDefaultFileTemplate());
        this.labelTemplate = DOMHelper.extractText(config, "label", "${event.getTime('yyyy.DDD.HH.mm.ss.SSSS')}");
        this.fullTemplate = parser.getTemplate();
        this.regions = ParseRegions.getInstance();
    }

    @Override
    public StringTree accept(CacheEvent event, Channel channel, RequestFilter[] request, MeasurementStorage cookieJar) {
        return new StringTreeLeaf(this, this.writeToBFEmail(event, channel, request));
    }

    protected String getConfig(String name) {
        return SodUtil.getText(SodUtil.getElement(this.config, name));
    }

    protected synchronized boolean writeToBFEmail(CacheEvent event, Channel channel, RequestFilter[] request) {
        WaveformProcessContext ctx = new WaveformProcessContext(event, channel, request, new RequestFilter[0], new LocalSeismogramImpl[0], null);
        String bfastLoc = FissuresFormatter.filize(this.velocitizer.evaluate(this.fullTemplate, (VelocityContext)ctx));
        File bfFile = new File(bfastLoc);
        File parent = bfFile.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new RuntimeException("Unable to create directory." + String.valueOf(parent));
        }
        boolean fileExists = bfFile.exists();
        Writer out = null;
        try {
            out = new BufferedWriter(new FileWriter(bfFile.getAbsolutePath(), true));
            if (!fileExists) {
                this.insertEventHeader(event, out, this.velocitizer.evaluate(this.labelTemplate, (VelocityContext)ctx));
            }
            for (int i = 0; i < request.length; ++i) {
                this.insertRequest(channel, request, out, i);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Trouble writing breqfast request!", e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to close breqfast file!", e);
                }
            }
        }
        return true;
    }

    protected void optInsert(Writer out, String configName) throws IOException {
        this.optInsert(out, configName, configName.toUpperCase());
    }

    protected void optInsert(Writer out, String configName, String fieldName) throws IOException {
        if (SodUtil.getElement(this.config, configName) != null) {
            this.insert(out, configName, fieldName);
        }
    }

    protected void insert(Writer out, String configName) throws IOException {
        this.insert(out, configName, configName.toUpperCase());
    }

    protected void insert(Writer out, String configName, String fieldName) throws IOException {
        out.write("." + fieldName + " " + this.getConfig(configName) + nl);
    }

    protected void insertRequest(Channel channel, RequestFilter[] request, Writer out, int i) throws IOException {
        Instant start = request[i].startTime;
        Instant end = request[i].endTime;
        out.write(channel.getStation().getCode() + " " + channel.getNetworkCode() + " " + this.format.format(start) + this.tenths.format(start).substring(0, 1) + " " + this.format.format(end) + this.tenths.format(end).substring(0, 1) + " 1 " + channel.getCode() + " " + channel.getLocCode() + nl);
    }

    protected void insertEventHeader(CacheEvent event, Writer out, String label) throws IOException {
        this.insert(out, "name");
        this.insert(out, "inst");
        this.insert(out, "mail");
        this.insert(out, "email");
        this.insert(out, "phone");
        this.insert(out, "fax");
        this.insert(out, "media");
        this.insert(out, "altmedia1", "ALTERNATIVE MEDIA");
        this.insert(out, "altmedia2", "ALTERNATIVE MEDIA");
        OriginImpl o = EventUtil.extractOrigin(event);
        out.write(".SOURCE ~" + o.getCatalog() + " " + o.getContributor() + "~unknown~unknown~\n");
        Instant oTime = o.getOriginTime();
        out.write(".HYPO ~" + this.format.format(oTime) + this.tenths.format(oTime) + "~" + o.getLocation().latitude + "~" + o.getLocation().longitude + "~" + o.getLocation().depth.convertTo(UnitImpl.KILOMETER).getValue() + "~0~" + event.get_attributes().region.number + "~" + this.regions.getRegionName(event.get_attributes().region) + "~\n");
        for (int j = 0; j < o.getMagnitudes().length; ++j) {
            out.write(".MAGNITUDE ~" + o.getMagnitudes()[j].value + "~" + o.getMagnitudes()[j].type + "~\n");
        }
        this.insert(out, "quality");
        out.write(".LABEL " + label + nl);
        out.write(".END\n");
        out.write(nl);
    }

    protected String getDefaultWorkingDir() {
        return "breqfast";
    }

    protected String getDefaultFileTemplate() {
        return "${event.getTime('yyyy.DDD.HH.mm.ss.SSSS')}.breq";
    }
}

