/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.origin;

import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.model.common.QuantityImpl;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.event.EventAttrImpl;
import edu.sc.seis.sod.model.event.OriginImpl;
import edu.sc.seis.sod.source.event.EventSource;
import edu.sc.seis.sod.status.Fail;
import edu.sc.seis.sod.status.Pass;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.subsetter.origin.RemoveEventDuplicate;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class SimilarEvent
extends RemoveEventDuplicate {
    ArrayList<CacheEvent> eventList = new ArrayList();

    public SimilarEvent(Element config) throws ConfigurationException {
        super(config);
        Element sourceElement = SodUtil.getFirstEmbeddedElement(config);
        EventSource source = (EventSource)SodUtil.load(sourceElement, new String[]{"event"});
        while (source.hasNext()) {
            CacheEvent[] events = source.next();
            for (int i = 0; i < events.length; ++i) {
                this.eventList.add(events[i]);
            }
        }
    }

    public SimilarEvent(CacheEvent[] events) {
        for (int i = 0; i < events.length; ++i) {
            this.eventList.add(events[i]);
        }
    }

    @Override
    public StringTree accept(CacheEvent eventAccess, EventAttrImpl eventAttr, OriginImpl preferred_origin) throws Exception {
        for (CacheEvent e : this.getEventsNearTimeAndDepth(preferred_origin)) {
            if (!e.equals(eventAccess) && !this.isDistanceClose(e, preferred_origin)) continue;
            return new Pass(this);
        }
        return new Fail(this);
    }

    @Override
    public List<CacheEvent> getEventsNearTimeAndDepth(OriginImpl preferred_origin) {
        ArrayList<CacheEvent> out = new ArrayList<CacheEvent>();
        for (CacheEvent event : this.eventList) {
            if (!this.isTimeOK(event, preferred_origin) || !this.isDepthOK(event, preferred_origin)) continue;
            out.add(event);
        }
        return out;
    }

    private boolean isTimeOK(CacheEvent event, OriginImpl preferred_origin) {
        Instant eventTime = event.getOrigin().getOriginTime();
        Instant originTime = preferred_origin.getOriginTime();
        return Duration.between(originTime, eventTime).abs().toNanos() < this.timeVariance.toNanos();
    }

    private boolean isDepthOK(CacheEvent event, OriginImpl preferred_origin) {
        QuantityImpl eventDepth = event.getOrigin().getLocation().depth;
        QuantityImpl originDepth = preferred_origin.getLocation().depth;
        double difference = eventDepth.subtract(originDepth).getValue(this.depthVariance.get_unit());
        return Math.abs(difference) <= this.depthVariance.getValue();
    }
}

