/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.origin;

import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.XMLUtil;
import edu.sc.seis.sod.hibernate.StatefulEventDB;
import edu.sc.seis.sod.model.common.DistAz;
import edu.sc.seis.sod.model.common.QuantityImpl;
import edu.sc.seis.sod.model.common.TimeRange;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.event.EventAttrImpl;
import edu.sc.seis.sod.model.event.OriginImpl;
import edu.sc.seis.sod.model.event.StatefulEvent;
import edu.sc.seis.sod.model.status.Standing;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.origin.OriginSubsetter;
import edu.sc.seis.sod.util.time.ClockUtil;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class RemoveEventDuplicate
implements OriginSubsetter {
    protected Duration timeVariance = Duration.ofSeconds(10L);
    protected QuantityImpl distanceVariance = new QuantityImpl(0.5, UnitImpl.DEGREE);
    protected QuantityImpl depthVariance = new QuantityImpl(100.0, UnitImpl.KILOMETER);
    private StatefulEventDB eventTable;
    private static Logger logger = LoggerFactory.getLogger(RemoveEventDuplicate.class);

    public RemoveEventDuplicate(Element config) throws ConfigurationException {
        Element el = XMLUtil.getElement(config, "timeVariance");
        if (el != null) {
            this.setTimeVariance(ClockUtil.durationFrom(SodUtil.loadQuantity(el)));
        }
        if ((el = XMLUtil.getElement(config, "distanceVariance")) != null) {
            this.setDistanceVariance(SodUtil.loadQuantity(el));
        }
        if ((el = XMLUtil.getElement(config, "depthVariance")) != null) {
            this.setDepthVariance(SodUtil.loadQuantity(el));
        }
    }

    public RemoveEventDuplicate(Duration timeVariance, QuantityImpl distanceVariance, QuantityImpl depthVariance) throws ConfigurationException {
        this.setTimeVariance(timeVariance);
        this.setDistanceVariance(distanceVariance);
        this.setDepthVariance(depthVariance);
    }

    public RemoveEventDuplicate() {
    }

    public StatefulEventDB getEventStatusTable() throws SQLException {
        if (this.eventTable == null) {
            this.eventTable = StatefulEventDB.getSingleton();
        }
        return this.eventTable;
    }

    @Override
    public StringTree accept(CacheEvent eventAccess, EventAttrImpl eventAttr, OriginImpl preferred_origin) throws Exception {
        for (StatefulEvent statefulEvent : this.getEventsNearTimeAndDepth(preferred_origin)) {
            if (statefulEvent.getOrigin().equals(preferred_origin) || !this.isDistanceClose(statefulEvent, preferred_origin)) continue;
            return new StringTreeLeaf(this, false);
        }
        return new StringTreeLeaf(this, true);
    }

    public boolean isDistanceClose(CacheEvent eventA, OriginImpl originB) {
        OriginImpl curOrig = eventA.getOrigin();
        DistAz distAz = new DistAz(curOrig.getLocation(), originB.getLocation());
        if (this.distanceVariance.getUnit().isConvertableTo(UnitImpl.DEGREE)) {
            return distAz.getDelta() < this.distanceVariance.convertTo(UnitImpl.DEGREE).getValue();
        }
        return distAz.getDelta() * 6371.0 < this.distanceVariance.convertTo(UnitImpl.KILOMETER).getValue();
    }

    public List<CacheEvent> getEventsNearTimeAndDepth(OriginImpl preferred_origin) throws SQLException {
        Instant originTime = preferred_origin.getOriginTime();
        Instant minTime = originTime.minus(this.timeVariance);
        Instant maxTime = originTime.plus(this.timeVariance);
        QuantityImpl originDepth = QuantityImpl.createQuantityImpl(preferred_origin.getLocation().depth);
        QuantityImpl depthRangeImpl = QuantityImpl.createQuantityImpl(this.depthVariance);
        QuantityImpl minDepth = originDepth.subtract(depthRangeImpl);
        QuantityImpl maxDepth = originDepth.add(depthRangeImpl);
        List<StatefulEvent> timeEvents = this.getEventStatusTable().getEventInTimeRangeRegardlessOfStatus(new TimeRange(minTime, maxTime));
        ArrayList<CacheEvent> out = new ArrayList<CacheEvent>();
        for (StatefulEvent e : timeEvents) {
            if (e.getStatus().getStanding().equals(Standing.INIT) || e.getStatus().getStanding().equals(Standing.IN_PROG) || e.getStatus().getStanding().equals(Standing.SUCCESS)) {
                QuantityImpl depth = e.getOrigin().getLocation().depth;
                if (depth.greaterThanEqual(minDepth) && depth.lessThanEqual(maxDepth)) {
                    out.add(e);
                    logger.debug("Considering for RemoveEventDup: " + String.valueOf(e));
                    continue;
                }
                logger.debug("Not considering (depth=" + String.valueOf(depth) + ") for RemoveEventDup: " + String.valueOf(e));
                continue;
            }
            logger.debug("Not considering (status=" + String.valueOf(e.getStatus()) + ") for RemoveEventDup: " + String.valueOf(e));
        }
        return out;
    }

    protected void setTimeVariance(Duration timeVariance) throws ConfigurationException {
        this.timeVariance = timeVariance;
    }

    protected void setDistanceVariance(QuantityImpl maxDistance) throws ConfigurationException {
        if (!maxDistance.getUnit().isConvertableTo(UnitImpl.DEGREE) && !maxDistance.getUnit().isConvertableTo(UnitImpl.KILOMETER)) {
            throw new ConfigurationException("Units must be convertible to DEGREE or KILOMETER: " + String.valueOf(maxDistance.getUnit()));
        }
        this.distanceVariance = maxDistance;
    }

    protected void setDepthVariance(QuantityImpl depthVariance) throws ConfigurationException {
        if (!depthVariance.getUnit().isConvertableTo(UnitImpl.KILOMETER)) {
            throw new ConfigurationException("Units must be convertible to KILOMETER: " + String.valueOf(depthVariance.getUnit()));
        }
        this.depthVariance = depthVariance;
    }
}

