/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.origin;

import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.DOMHelper;
import edu.sc.seis.sod.MicroSecondDateSupplier;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.model.common.TimeRange;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.event.EventAttrImpl;
import edu.sc.seis.sod.model.event.OriginImpl;
import edu.sc.seis.sod.source.event.MicroSecondTimeRangeSupplier;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.origin.NetworkTimeRange;
import edu.sc.seis.sod.subsetter.origin.OriginSubsetter;
import edu.sc.seis.sod.util.time.ClockUtil;
import java.time.Instant;
import javax.xml.xpath.XPathException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OriginTimeRange
implements OriginSubsetter,
MicroSecondTimeRangeSupplier {
    private MicroSecondDateSupplier begin;
    private MicroSecondDateSupplier end;

    public OriginTimeRange(Element config) throws ConfigurationException {
        this.begin = this.makeLoader(config, "startTime");
        this.end = this.makeLoader(config, "endTime");
    }

    private MicroSecondDateSupplier makeLoader(Element config, String time) throws ConfigurationException {
        Element timeEl;
        try {
            timeEl = DOMHelper.getElement(config, time);
        }
        catch (XPathException e) {
            throw new ConfigurationException("problem with '" + time + "'", e);
        }
        if (timeEl == null && time.indexOf("end") != -1) {
            return new MicroSecondDateSupplier(){

                @Override
                public Instant load() {
                    return ClockUtil.wayFuture();
                }
            };
        }
        Node network = null;
        for (int i = 0; i < timeEl.getChildNodes().getLength(); ++i) {
            if (!(timeEl.getChildNodes().item(i) instanceof Element) || !timeEl.getChildNodes().item(i).getLocalName().startsWith("network")) continue;
            network = (Element)timeEl.getChildNodes().item(i);
            break;
        }
        if (network != null) {
            final String netElName = network.getLocalName();
            final NetworkTimeRange ntr = new NetworkTimeRange();
            return new MicroSecondDateSupplier(){

                @Override
                public Instant load() {
                    if (netElName.indexOf("Start") != -1) {
                        return ntr.getMSTR().getBeginTime();
                    }
                    return ntr.getMSTR().getEndTime();
                }
            };
        }
        return SodUtil.loadTime(timeEl, time.indexOf("end") != -1);
    }

    @Override
    public synchronized TimeRange getMSTR() {
        return new TimeRange(this.begin.load(), this.end.load());
    }

    @Override
    public StringTree accept(CacheEvent event, EventAttrImpl eventAttr, OriginImpl origin) {
        return new StringTreeLeaf(this, this.getMSTR().contains(origin.getOriginTime()));
    }
}

