/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.origin;

import edu.sc.seis.sod.model.common.Area;
import edu.sc.seis.sod.model.common.DistAz;
import edu.sc.seis.sod.model.common.PointDistanceAreaImpl;
import edu.sc.seis.sod.model.common.QuantityImpl;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.event.EventAttrImpl;
import edu.sc.seis.sod.model.event.OriginImpl;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.origin.AbstractOriginPoint;
import edu.sc.seis.sod.subsetter.origin.OriginSubsetter;
import org.w3c.dom.Element;

public class OriginPointDistance
extends AbstractOriginPoint
implements OriginSubsetter {
    private double min = this.getMin().convertTo(UnitImpl.DEGREE).get_value();
    private double max = this.getMax().convertTo(UnitImpl.DEGREE).get_value();

    public OriginPointDistance(Element config) throws Exception {
        super(config);
    }

    @Override
    public StringTree accept(CacheEvent event, EventAttrImpl eventAttr, OriginImpl origin) {
        double oLat = origin.getLocation().latitude;
        double oLon = origin.getLocation().longitude;
        DistAz distaz = new DistAz(this.latitude, this.longitude, oLat, oLon);
        double delta = distaz.getDelta();
        return new StringTreeLeaf(this, this.min <= delta && this.max >= delta);
    }

    public Area getArea() {
        return new PointDistanceAreaImpl((float)this.latitude, (float)this.longitude, new QuantityImpl(this.min, UnitImpl.DEGREE), new QuantityImpl(this.max, UnitImpl.DEGREE));
    }
}

