/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.origin;

import edu.sc.seis.sod.model.common.DistAz;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.event.EventAttrImpl;
import edu.sc.seis.sod.model.event.OriginImpl;
import edu.sc.seis.sod.status.Fail;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.AzimuthUtils;
import edu.sc.seis.sod.subsetter.origin.AbstractOriginPoint;
import edu.sc.seis.sod.subsetter.origin.OriginSubsetter;
import org.w3c.dom.Element;

public class OriginPointAzimuth
extends AbstractOriginPoint
implements OriginSubsetter {
    private double min = this.getMin().convertTo(UnitImpl.DEGREE).get_value();
    private double max = this.getMax().convertTo(UnitImpl.DEGREE).get_value();

    public OriginPointAzimuth(Element config) throws Exception {
        super(config);
    }

    @Override
    public StringTree accept(CacheEvent event, EventAttrImpl eventAttr, OriginImpl origin) {
        double oLat = origin.getLocation().latitude;
        double oLon = origin.getLocation().longitude;
        DistAz distaz = new DistAz(this.latitude, this.longitude, oLat, oLon);
        if (AzimuthUtils.isAzimuthBetween(distaz, this.min, this.max)) {
            return new StringTreeLeaf(this, true);
        }
        return new Fail((Object)this, "reject azimuth az=" + distaz.getAz() + "  " + this.min + " " + this.max);
    }
}

