/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.origin;

import edu.sc.seis.seisFile.fdsnws.stationxml.BaseNodeType;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.Arm;
import edu.sc.seis.sod.ArmListener;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.NetworkArm;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.UserConfigurationException;
import edu.sc.seis.sod.model.common.TimeRange;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.event.EventAttrImpl;
import edu.sc.seis.sod.model.event.OriginImpl;
import edu.sc.seis.sod.source.event.MicroSecondTimeRangeSupplier;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.origin.OriginSubsetter;
import edu.sc.seis.sod.util.time.ClockUtil;
import java.util.List;

public class NetworkTimeRange
implements OriginSubsetter,
ArmListener,
MicroSecondTimeRangeSupplier {
    private boolean finished;
    private NetworkArm arm;
    private Object finishLock = new Object();
    private TimeRange range;

    public NetworkTimeRange() throws ConfigurationException {
        Start.add(this);
        Start.getRunProps().setAllowDeadNets(true);
    }

    @Override
    public void starting(Arm arm) throws ConfigurationException {
        if (!(arm instanceof NetworkArm)) {
            return;
        }
        this.arm = (NetworkArm)arm;
        this.arm.add(this);
    }

    @Override
    public void started() throws ConfigurationException {
        if (this.arm == null) {
            throw new UserConfigurationException("Using a network time in the event arm requires a network arm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finished(Arm arm) {
        Object object = this.finishLock;
        synchronized (object) {
            this.finished = true;
            this.finishLock.notify();
        }
    }

    @Override
    public StringTree accept(CacheEvent event, EventAttrImpl eventAttr, OriginImpl origin) {
        return new StringTreeLeaf(this, this.getMSTR().contains(origin.getOriginTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized TimeRange getMSTR() {
        if (this.range != null) {
            return this.range;
        }
        Object object = this.finishLock;
        synchronized (object) {
            if (!this.finished) {
                try {
                    this.finishLock.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        List<Network> nets = this.arm.getSuccessfulNetworks();
        for (Network net : nets) {
            Station[] stas = this.arm.getSuccessfulStations(net);
            for (int j = 0; j < stas.length; ++j) {
                List<Channel> chans = this.arm.getSuccessfulChannels(stas[j]);
                for (Channel c : chans) {
                    TimeRange chanRange = new TimeRange((BaseNodeType)c);
                    if (this.range == null) {
                        this.range = chanRange;
                        continue;
                    }
                    if (chanRange.getBeginTime().isBefore(this.range.getBeginTime())) {
                        this.range = new TimeRange(chanRange.getBeginTime(), this.range.getEndTime());
                    }
                    if (!chanRange.getEndTime().isAfter(this.range.getEndTime())) continue;
                    this.range = new TimeRange(this.range.getBeginTime(), chanRange.getEndTime());
                }
            }
        }
        if (this.range == null) {
            this.range = new TimeRange(ClockUtil.now(), ClockUtil.now());
        }
        return this.range;
    }
}

