/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.origin;

import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.event.EventAttrImpl;
import edu.sc.seis.sod.model.event.Magnitude;
import edu.sc.seis.sod.model.event.OriginImpl;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.MagType;
import edu.sc.seis.sod.subsetter.RangeSubsetter;
import edu.sc.seis.sod.subsetter.origin.OriginSubsetter;
import edu.sc.seis.sod.util.display.EventUtil;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MagnitudeRange
extends RangeSubsetter
implements OriginSubsetter {
    private StringValueAcceptor typeAcceptor = new StringValueAcceptor(){

        @Override
        public boolean accept(Magnitude mag, String value) {
            return mag.type != null && mag.type.equals(value);
        }
    };
    private StringValueAcceptor contribAcceptor = new StringValueAcceptor(){

        @Override
        public boolean accept(Magnitude mag, String value) {
            return mag.contributor != null && mag.contributor.equals(value);
        }
    };
    private String[] searchTypes = new String[0];
    private String[] contributors = new String[0];
    private int valueTolerance = 0;
    private static final int ANY = 0;
    private static final int LARGEST = 1;
    private static final int SMALLEST = 2;

    public MagnitudeRange() {
    }

    public MagnitudeRange(Element config) throws ConfigurationException {
        super(config);
        this.searchTypes = this.parseSearchElements(config, "magType");
        this.contributors = this.parseSearchElements(config, "contributor");
        this.parseValueTolerance(config);
    }

    @Override
    public StringTree accept(CacheEvent event, EventAttrImpl eventAttr, OriginImpl origin) {
        return new StringTreeLeaf(this, this.getAcceptable(origin.getMagnitudes()).length > 0);
    }

    public String[] getSearchTypes() {
        return this.searchTypes;
    }

    public String[] getContributors() {
        return this.contributors;
    }

    public Magnitude[] getAcceptable(Magnitude[] mags) {
        ArrayList<Magnitude> matchList = new ArrayList<Magnitude>();
        for (int i = 0; i < mags.length; ++i) {
            if (this.contributors.length != 0 && !this.accept(this.contribAcceptor, mags[i], this.contributors) || this.searchTypes.length != 0 && !this.accept(this.typeAcceptor, mags[i], this.searchTypes)) continue;
            matchList.add(mags[i]);
        }
        Magnitude[] matches = matchList.toArray(new Magnitude[0]);
        if (matches.length > 0) {
            if (this.valueTolerance == 1) {
                matches = new Magnitude[]{EventUtil.getLargest(matches)};
            } else if (this.valueTolerance == 2) {
                matches = new Magnitude[]{EventUtil.getSmallest(matches)};
            }
        }
        return this.acceptValues(matches);
    }

    private boolean accept(StringValueAcceptor acceptor, Magnitude mag, String[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (!acceptor.accept(mag, values[i])) continue;
            return true;
        }
        return false;
    }

    private Magnitude[] acceptValues(Magnitude[] mags) {
        ArrayList<Magnitude> accepted = new ArrayList<Magnitude>();
        for (int i = 0; i < mags.length; ++i) {
            double doubleMag = (double)(1000.0f * mags[i].value) / 1000.0;
            if (!this.accept(doubleMag)) continue;
            accepted.add(mags[i]);
        }
        return accepted.toArray(new Magnitude[0]);
    }

    private void parseValueTolerance(Element config) {
        this.valueTolerance = SodUtil.getElement(config, "largest") != null ? 1 : (SodUtil.getElement(config, "smallest") != null ? 2 : 0);
    }

    private String[] parseSearchElements(Element config, String elementName) throws ConfigurationException {
        ArrayList<String> values = new ArrayList<String>();
        NodeList childNodes = config.getChildNodes();
        for (int counter = 0; counter < childNodes.getLength(); ++counter) {
            String tagName;
            Node node = childNodes.item(counter);
            if (!(node instanceof Element) || !(tagName = ((Element)node).getTagName()).equals(elementName)) continue;
            if (tagName.equals("magType")) {
                MagType magType = (MagType)SodUtil.load((Element)node, "");
                values.add(magType.getType());
                continue;
            }
            if (!tagName.equals("contributor")) continue;
            values.add(SodUtil.getNestedText((Element)node));
        }
        return values.toArray(new String[values.size()]);
    }

    @Override
    public String toString() {
        int i;
        Object out = super.toString();
        out = (String)out + " types={";
        for (i = 0; i < this.searchTypes.length; ++i) {
            out = (String)out + this.searchTypes[i];
            if (i == this.searchTypes.length - 1) continue;
            out = (String)out + ",";
        }
        out = (String)out + "} contributors=={";
        for (i = 0; i < this.contributors.length; ++i) {
            out = (String)out + this.contributors[i];
            if (i == this.contributors.length - 1) continue;
            out = (String)out + ",";
        }
        out = (String)out + "}";
        return out;
    }

    private static interface StringValueAcceptor {
        public boolean accept(Magnitude var1, String var2);
    }
}

