/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.origin;

import edu.sc.seis.sod.DOMHelper;
import edu.sc.seis.sod.model.common.Location;
import edu.sc.seis.sod.model.common.QuantityImpl;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.event.EventAttrImpl;
import edu.sc.seis.sod.model.event.FlinnEngdahlRegion;
import edu.sc.seis.sod.model.event.Magnitude;
import edu.sc.seis.sod.model.event.OriginImpl;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.origin.OriginSubsetter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.w3c.dom.Element;

public class CSVEventPrinter
implements OriginSubsetter {
    private File file;
    private static final String COM = ", ";
    private static final String STDOUT = "<stdout>";

    public CSVEventPrinter(Element config) throws Exception {
        this(DOMHelper.extractText(config, "filename", STDOUT));
    }

    public CSVEventPrinter(String filename) throws Exception {
        if (!filename.equals(STDOUT)) {
            this.file = new File(filename);
        }
        this.createFileAndWriteHeaderIfNeeded();
    }

    @Override
    public StringTree accept(CacheEvent eventAccess, EventAttrImpl eventAttr, OriginImpl preferred_origin) throws Exception {
        StringBuffer buff = new StringBuffer();
        buff.append(preferred_origin.getOriginTime().toString() + COM);
        Location loc = preferred_origin.getLocation();
        buff.append(loc.latitude + COM);
        buff.append(loc.longitude + COM);
        QuantityImpl q = loc.depth;
        buff.append(q.getValue() + COM);
        buff.append(String.valueOf(q.getUnit()) + COM);
        StringBuffer magValBuf = new StringBuffer();
        StringBuffer magTypeBuf = new StringBuffer();
        StringBuffer magContribBuf = new StringBuffer();
        Magnitude[] mags = preferred_origin.getMagnitudes();
        for (int i = 0; i < mags.length; ++i) {
            magValBuf.append(mags[i].value);
            if (mags[i].type == null || mags[i].type.equals("")) {
                magTypeBuf.append("");
            } else {
                magTypeBuf.append(mags[i].type);
            }
            if (mags[i].contributor == null || mags[i].contributor.equals("")) {
                magContribBuf.append("");
            } else {
                magContribBuf.append(mags[i].contributor);
            }
            if (i >= mags.length - 1) continue;
            magValBuf.append(':');
            magTypeBuf.append(':');
            magContribBuf.append(':');
        }
        buff.append(String.valueOf(magValBuf) + COM);
        buff.append(String.valueOf(magTypeBuf) + COM);
        buff.append(String.valueOf(magContribBuf) + COM);
        buff.append(preferred_origin.getCatalog() + COM);
        buff.append(preferred_origin.getContributor() + COM);
        buff.append("\"" + eventAttr.name + "\", ");
        FlinnEngdahlRegion region = eventAttr.region;
        buff.append(region.number + COM);
        buff.append("" + region.type.value());
        if (this.file == null) {
            System.out.println(buff.toString());
        } else {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.file, true));
            writer.write(buff.toString());
            writer.newLine();
            writer.close();
        }
        return new StringTreeLeaf(this, true);
    }

    private void createFileAndWriteHeaderIfNeeded() throws IOException {
        if (this.file == null) {
            System.out.println(this.getHeader());
        } else if (!this.file.exists()) {
            this.file.getAbsoluteFile().getParentFile().mkdirs();
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.file));
            writer.write(this.getHeader());
            writer.newLine();
            writer.close();
        }
    }

    private String getHeader() {
        return "time, latitude, longitude, depth, depthUnits, magnitude, magnitudeType, magnitudeContributor, catalog, contributor, name, flinnEngdahlRegion, flinnEngdahlRegionType";
    }
}

