/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.origin;

import edu.sc.seis.sod.DOMHelper;
import edu.sc.seis.sod.UserConfigurationException;
import edu.sc.seis.sod.subsetter.DistanceRangeSubsetter;
import edu.sc.seis.sod.subsetter.LatitudeRange;
import edu.sc.seis.sod.subsetter.LongitudeRange;
import org.w3c.dom.Element;

public class AbstractOriginPoint
extends DistanceRangeSubsetter {
    protected double latitude = 0.0;
    protected double longitude = 0.0;

    public AbstractOriginPoint(Element config) throws Exception {
        super(config);
        double[] out = AbstractOriginPoint.getLatLon(config, config.getNodeName());
        this.latitude = out[0];
        this.longitude = out[1];
    }

    public static double[] getLatLon(Element config, String extractor) throws UserConfigurationException {
        double[] out = new double[]{DOMHelper.extractDouble(config, "latitude", 0.0), DOMHelper.extractDouble(config, "longitude", 0.0)};
        LatitudeRange.check(out[0], extractor);
        out[1] = LongitudeRange.sanitize(out[1], extractor);
        return out;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }
}

