/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.network;

import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.status.Fail;
import edu.sc.seis.sod.status.Pass;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.subsetter.network.NetworkSubsetter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;

public class NetworkCode
implements NetworkSubsetter {
    private String desiredCode;
    private String year;
    private static final Pattern TEMP_NET = Pattern.compile("([1-9XYZ][0-9A-Z])(\\d{4})");
    private static final Pattern ANY_NET = Pattern.compile("([0-9A-Z][0-9A-Z]?)(\\d{4})?");

    public NetworkCode(Element config) throws ConfigurationException {
        this.desiredCode = SodUtil.getText(config);
        if (!ANY_NET.matcher(this.desiredCode).matches()) {
            throw new ConfigurationException("Code '" + this.desiredCode + "' does not look like a network code, valid examples are G, IU and YJ2007");
        }
        Matcher m = TEMP_NET.matcher(this.desiredCode);
        if (m.matches()) {
            this.desiredCode = m.group(1);
            this.year = m.group(2);
        }
    }

    @Override
    public StringTree accept(Network attr) throws Exception {
        if (attr.getCode().equals(this.desiredCode) && (this.year == null || this.year.length() == 4 && this.year.equals(attr.getStartYearString()))) {
            return new Pass(this);
        }
        return new Fail(this);
    }

    public String getCode() {
        return this.desiredCode;
    }
}

