/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.eventStation;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SeismicPhaseFactory;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauModelLoader;
import edu.sc.seis.TauP.TauP_Time;
import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.DOMHelper;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.common.DistAz;
import edu.sc.seis.sod.model.common.Location;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.event.OriginImpl;
import edu.sc.seis.sod.status.Fail;
import edu.sc.seis.sod.status.Pass;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.subsetter.eventStation.EventStationSubsetter;
import edu.sc.seis.sod.subsetter.eventStation.PhaseExists;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class PhaseWithoutInterference
extends PhaseExists
implements EventStationSubsetter {
    boolean onlyFirst = true;
    double beginOffset;
    double endOffset;
    SeismicPhase mainPhase;
    TauModel tMod;
    int arrivalIndex = 0;
    List<SeismicPhase> phases = new ArrayList<SeismicPhase>();
    List<String> interferingPhaseNames = new ArrayList<String>();
    private static Logger logger = LoggerFactory.getLogger(PhaseWithoutInterference.class);

    public PhaseWithoutInterference(Element config) throws ConfigurationException, TauModelException {
        super(config);
        List<Element> phElements = SodUtil.getAllElements(config, "interferingPhase");
        this.tMod = TauModelLoader.load((String)this.modelName);
        this.mainPhase = SeismicPhaseFactory.createPhase((String)this.phaseName, (TauModel)this.tMod, (double)0.0);
        this.beginOffset = TimeUtils.durationToDoubleSeconds((Duration)SodUtil.loadTimeInterval(DOMHelper.extractElement(config, "beginOffset")));
        this.endOffset = TimeUtils.durationToDoubleSeconds((Duration)SodUtil.loadTimeInterval(DOMHelper.extractElement(config, "endOffset")));
        for (Element element : phElements) {
            List newPhases = TauP_Time.getPhaseNames((String)SodUtil.getNestedText(element));
            for (String s : newPhases) {
                if (!s.equals(this.phaseName)) {
                    this.interferingPhaseNames.add(s);
                    continue;
                }
                logger.warn("Phase cannot interfer with itself: " + this.phaseName + ", skipping...");
            }
        }
        this.arrivalIndex = DOMHelper.extractInt(config, "arrivalIndex", 1);
        if (this.arrivalIndex > 0) {
            --this.arrivalIndex;
        }
    }

    @Override
    public StringTree accept(CacheEvent event, Station station, MeasurementStorage cookieJar) throws Exception {
        double mainTime;
        OriginImpl origin = event.get_preferred_origin();
        double depth = origin.getLocation().depth.getValue(UnitImpl.KILOMETER);
        List<List<Arrival>> arrivals = this.calcArrivals(depth, new DistAz(Location.of(station), origin.getLocation()).getDelta());
        List<Arrival> mainArrivals = arrivals.get(0);
        if (this.arrivalIndex >= 0 && mainArrivals.size() > this.arrivalIndex) {
            mainTime = mainArrivals.get(this.arrivalIndex).getTime();
        } else if (this.arrivalIndex < 0 && mainArrivals.size() > -1 * this.arrivalIndex) {
            mainTime = mainArrivals.get(mainArrivals.size() + this.arrivalIndex).getTime();
        } else {
            return new Fail((Object)this, "No arrival for " + this.phaseName + " (" + (this.arrivalIndex < 0 ? this.arrivalIndex : this.arrivalIndex + 1) + ")");
        }
        double windowBegin = mainTime + this.beginOffset;
        double windowEnd = mainTime + this.endOffset;
        List<List<Arrival>> interfereArrivals = arrivals.subList(1, arrivals.size());
        block0: for (List<Arrival> list : interfereArrivals) {
            for (Arrival arrival : list) {
                logger.debug("check: " + arrival.getName() + "  " + windowBegin + " < " + arrival.getTime() + " < " + windowEnd);
                if (arrival.getTime() >= windowBegin && arrival.getTime() <= windowEnd) {
                    return new Fail((Object)this, arrival.getName() + " (" + arrival.getTime() + " s)   interferes with " + this.mainPhase.getName() + " (" + mainTime + " s)");
                }
                if (!this.onlyFirst) continue;
                continue block0;
            }
        }
        return new Pass(this);
    }

    protected synchronized List<List<Arrival>> calcArrivals(double depth, double degrees) throws TauModelException {
        if (this.mainPhase.getTauModel().getSourceDepth() != depth) {
            this.mainPhase = SeismicPhaseFactory.createPhase((String)this.phaseName, (TauModel)this.tMod, (double)depth);
            this.phases.clear();
            for (String phaseName : this.interferingPhaseNames) {
                this.phases.add((SeismicPhase)SeismicPhaseFactory.createPhase((String)phaseName, (TauModel)this.tMod, (double)depth));
            }
        }
        ArrayList<List<Arrival>> out = new ArrayList<List<Arrival>>();
        out.add(this.mainPhase.calcTime(degrees));
        for (SeismicPhase phase : this.phases) {
            out.add(phase.calcTime(degrees));
        }
        return out;
    }
}

