/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.eventStation;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauP_Path;
import edu.sc.seis.TauP.TauP_Pierce;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.common.Area;
import edu.sc.seis.sod.model.common.BoxAreaImpl;
import edu.sc.seis.sod.model.common.GlobalAreaImpl;
import edu.sc.seis.sod.model.common.QuantityImpl;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.event.OriginImpl;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.eventStation.Absolute;
import edu.sc.seis.sod.subsetter.eventStation.EventStationSubsetter;
import edu.sc.seis.sod.subsetter.eventStation.PhaseInteractionType;
import edu.sc.seis.sod.subsetter.eventStation.Relative;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class PhaseInteraction
implements EventStationSubsetter {
    private String modelName = "prem";
    private String phaseName = null;
    private String interactionStyle = null;
    private int interactionNumber = 1;
    private PhaseInteractionType phaseInteractionType = null;
    private TauP_Pierce tauPPierce;
    private TauP_Path tauPPath;

    public PhaseInteraction(Element config) throws ConfigurationException {
        Element element = SodUtil.getElement(config, "modelName");
        if (element != null) {
            this.modelName = SodUtil.getNestedText(element);
        }
        if ((element = SodUtil.getElement(config, "phaseName")) != null) {
            this.phaseName = SodUtil.getNestedText(element);
        }
        if ((element = SodUtil.getElement(config, "interactionStyle")) != null) {
            this.interactionStyle = SodUtil.getNestedText(element);
        }
        if ((element = SodUtil.getElement(config, "interactionNumber")) != null) {
            this.interactionNumber = Integer.parseInt(SodUtil.getNestedText(element));
        }
        if ((element = SodUtil.getElement(config, "relative")) != null) {
            this.phaseInteractionType = (PhaseInteractionType)SodUtil.load(element, "eventStation");
        }
        if ((element = SodUtil.getElement(config, "absolute")) != null) {
            this.phaseInteractionType = (PhaseInteractionType)SodUtil.load(element, "eventStation");
        }
        try {
            this.tauPPierce = new TauP_Pierce(this.modelName);
            this.tauPPierce.clearPhaseNames();
            this.tauPPierce.parsePhaseList(this.phaseName);
            this.tauPPath = new TauP_Path(this.tauPPierce.getTauModel());
            this.tauPPath.clearPhaseNames();
            this.tauPPath.parsePhaseList(this.phaseName);
        }
        catch (TauModelException e) {
            throw new ConfigurationException("Can't load TauP_Pierce", e);
        }
    }

    @Override
    public StringTree accept(CacheEvent event, Station station, MeasurementStorage cookieJar) throws Exception {
        if (this.interactionStyle.equals("PATH")) {
            return new StringTreeLeaf(this, this.acceptPathInteraction(event, station));
        }
        return new StringTreeLeaf(this, this.acceptPierceInteraction(event, station));
    }

    public boolean acceptPathInteraction(CacheEvent event, Station station) throws Exception {
        OriginImpl origin = event.getOrigin();
        double originDepth = origin.getLocation().depth.convertTo(UnitImpl.KILOMETER).getValue();
        this.tauPPath.setSourceDepth(originDepth);
        double eventStationDistance = SphericalCoords.distance((double)origin.getLocation().latitude, (double)origin.getLocation().longitude, (double)station.getLatitude().getValue(), (double)station.getLongitude().getValue());
        double azimuth = SphericalCoords.azimuth((double)origin.getLocation().latitude, (double)origin.getLocation().longitude, (double)station.getLatitude().getValue(), (double)station.getLongitude().getValue());
        this.tauPPath.calculate(eventStationDistance);
        List arrivals = this.tauPPath.getArrivals();
        List<Arrival> requiredArrivals = this.getRequiredArrival(arrivals);
        if (requiredArrivals.size() == 0) {
            return false;
        }
        if (this.phaseInteractionType instanceof Relative) {
            return this.handleRelativePathInteraction(requiredArrivals, eventStationDistance);
        }
        return this.handleAbsolutePhaseInteraction(requiredArrivals, azimuth, origin, "PATH");
    }

    public boolean acceptPierceInteraction(CacheEvent event, Station station) throws Exception {
        OriginImpl origin = event.getOrigin();
        double originDepth = origin.getLocation().depth.convertTo(UnitImpl.KILOMETER).getValue();
        this.tauPPierce.setSourceDepth(originDepth);
        double eventStationDistance = SphericalCoords.distance((double)origin.getLocation().latitude, (double)origin.getLocation().longitude, (double)station.getLatitude().getValue(), (double)station.getLongitude().getValue());
        double azimuth = SphericalCoords.azimuth((double)origin.getLocation().latitude, (double)origin.getLocation().longitude, (double)station.getLatitude().getValue(), (double)station.getLongitude().getValue());
        this.tauPPierce.calculate(eventStationDistance);
        List arrivals = this.tauPPierce.getArrivals();
        List<Arrival> requiredArrivals = this.getRequiredArrival(arrivals);
        if (requiredArrivals.size() != 0) {
            if (this.phaseInteractionType instanceof Relative) {
                return this.handlePierceRelativePhaseInteraction(requiredArrivals, eventStationDistance);
            }
            return this.handleAbsolutePhaseInteraction(requiredArrivals, azimuth, origin, "PIERCE");
        }
        return false;
    }

    public boolean handlePierceRelativePhaseInteraction(List<Arrival> requiredArrivals, double eventStationDistance) throws Exception {
        for (int counter = 0; counter < requiredArrivals.size(); ++counter) {
            QuantityImpl maxDistance;
            QuantityImpl minDistance;
            QuantityImpl maxDepth;
            QuantityImpl minDepth;
            TimeDist[] timeDistArray = requiredArrivals.get(counter).getPierce();
            TimeDist timeDist = this.getRequiredTimeDist(timeDistArray);
            QuantityImpl timeDistDepth = new QuantityImpl(timeDist.getDepth(), UnitImpl.KILOMETER);
            QuantityImpl timeDistDistance = new QuantityImpl(timeDist.getDistDeg(), UnitImpl.DEGREE);
            if (((Relative)this.phaseInteractionType).getDepthRange() != null) {
                minDepth = ((Relative)this.phaseInteractionType).getDepthRange().getMinDepth();
                maxDepth = ((Relative)this.phaseInteractionType).getDepthRange().getMaxDepth();
            } else {
                minDepth = timeDistDepth;
                maxDepth = timeDistDepth;
            }
            if (((Relative)this.phaseInteractionType).getDistanceRange() != null) {
                if (((Relative)this.phaseInteractionType).getReference().equals("STATION")) {
                    timeDistDistance = new QuantityImpl(eventStationDistance - timeDist.getDistDeg(), UnitImpl.DEGREE);
                }
                minDistance = ((Relative)this.phaseInteractionType).getDistanceRange().getMin();
                maxDistance = ((Relative)this.phaseInteractionType).getDistanceRange().getMax();
            } else {
                minDistance = timeDistDistance;
                maxDistance = timeDistDistance;
            }
            if (!minDepth.lessThanEqual(timeDistDepth) || !maxDepth.greaterThanEqual(timeDistDepth) || !minDistance.lessThanEqual(timeDistDistance) || !maxDistance.greaterThanEqual(timeDistDistance)) continue;
            return true;
        }
        return false;
    }

    public boolean handleRelativePathInteraction(List<Arrival> requiredArrivals, double eventStationDistance) throws Exception {
        for (int counter = 0; counter < requiredArrivals.size(); ++counter) {
            TimeDist[] timeDistArray = requiredArrivals.get(counter).getPath();
            if (!this.checkForRelativePathInteraction(timeDistArray, 0, timeDistArray.length, eventStationDistance, requiredArrivals.get(counter).getDistDeg())) continue;
            return true;
        }
        return false;
    }

    public boolean checkForRelativePathInteraction(TimeDist[] timeDistArray, int start, int end, double eventStationDistance, double totalDistance) throws Exception {
        int counter = 0;
        if (end < start) {
            return false;
        }
        int mid = (start + end) / 2;
        TimeDist timeDist = timeDistArray[mid];
        QuantityImpl minDistance = null;
        QuantityImpl maxDistance = null;
        QuantityImpl timeDistDistance = new QuantityImpl(timeDist.getDistDeg(), UnitImpl.DEGREE);
        while ((double)counter < totalDistance) {
            QuantityImpl maxDepth;
            QuantityImpl minDepth;
            QuantityImpl timeDistDepth = new QuantityImpl(timeDist.getDepth(), UnitImpl.KILOMETER);
            if (((Relative)this.phaseInteractionType).getDepthRange() != null) {
                minDepth = ((Relative)this.phaseInteractionType).getDepthRange().getMinDepth();
                maxDepth = ((Relative)this.phaseInteractionType).getDepthRange().getMaxDepth();
            } else {
                minDepth = timeDistDepth;
                maxDepth = timeDistDepth;
            }
            if (((Relative)this.phaseInteractionType).getDistanceRange() != null) {
                if (((Relative)this.phaseInteractionType).getReference().equals("STATION")) {
                    timeDistDistance = new QuantityImpl(eventStationDistance - timeDist.getDistDeg(), UnitImpl.DEGREE);
                }
                minDistance = ((Relative)this.phaseInteractionType).getDistanceRange().getMin();
                maxDistance = ((Relative)this.phaseInteractionType).getDistanceRange().getMax();
            } else {
                minDistance = timeDistDistance;
                maxDistance = timeDistDistance;
            }
            if (minDepth.lessThanEqual(timeDistDepth) && maxDepth.greaterThanEqual(timeDistDepth)) {
                minDistance = new QuantityImpl(minDistance.getValue() + (double)counter, UnitImpl.DEGREE);
                maxDistance = new QuantityImpl((double)(360 + counter) - minDistance.getValue(), UnitImpl.DEGREE);
                QuantityImpl tempDistance = new QuantityImpl((double)counter - timeDistDistance.getValue(), UnitImpl.DEGREE);
                if (minDistance.lessThanEqual(timeDistDistance) && maxDistance.greaterThanEqual(timeDistDistance) || minDistance.lessThanEqual(tempDistance) && maxDistance.greaterThanEqual(tempDistance)) {
                    return true;
                }
            }
            counter += 360;
        }
        if (end < start) {
            return false;
        }
        if (minDistance.greaterThan(timeDistDistance)) {
            return this.checkForRelativePathInteraction(timeDistArray, mid, end, eventStationDistance, totalDistance);
        }
        if (maxDistance.lessThan(timeDistDistance)) {
            return this.checkForRelativePathInteraction(timeDistArray, start, mid, eventStationDistance, totalDistance);
        }
        return false;
    }

    public boolean handleAbsolutePhaseInteraction(List<Arrival> requiredArrivals, double azimuth, OriginImpl origin, String type) throws Exception {
        Area area = ((Absolute)this.phaseInteractionType).getArea();
        for (int i = 0; i < requiredArrivals.size(); ++i) {
            TimeDist[] timeDist = type.equals("PIERCE") ? requiredArrivals.get(i).getPierce() : requiredArrivals.get(i).getPath();
            azimuth = this.checkForLongway(requiredArrivals.get(i).getDistDeg(), azimuth);
            for (int counter = 0; counter < timeDist.length; ++counter) {
                QuantityImpl maxDepth;
                QuantityImpl minDepth;
                QuantityImpl timeDistDepth = new QuantityImpl(timeDist[0].getDepth(), UnitImpl.KILOMETER);
                if (((Absolute)this.phaseInteractionType).getDepthRange() != null) {
                    minDepth = ((Absolute)this.phaseInteractionType).getDepthRange().getMinDepth();
                    maxDepth = ((Absolute)this.phaseInteractionType).getDepthRange().getMaxDepth();
                } else {
                    minDepth = timeDistDepth;
                    maxDepth = timeDistDepth;
                }
                if (!minDepth.lessThanEqual(timeDistDepth) || !maxDepth.greaterThanEqual(timeDistDepth)) continue;
                if (area == null || area instanceof GlobalAreaImpl) {
                    return true;
                }
                double tLat = SphericalCoords.latFor((double)origin.getLocation().latitude, (double)origin.getLocation().longitude, (double)timeDist[counter].getDepth(), (double)azimuth);
                double tLon = SphericalCoords.lonFor((double)origin.getLocation().latitude, (double)origin.getLocation().longitude, (double)timeDist[counter].getDepth(), (double)azimuth);
                if (!(area instanceof BoxAreaImpl)) continue;
                BoxAreaImpl boxArea = (BoxAreaImpl)area;
                if (!(tLat >= (double)boxArea.min_latitude) || !(tLat <= (double)boxArea.max_latitude) || !(tLon >= (double)boxArea.min_longitude) || !(tLon <= (double)boxArea.max_longitude)) continue;
                return true;
            }
        }
        return false;
    }

    public TimeDist getRequiredTimeDist(TimeDist[] timeDist) {
        if (timeDist.length == 0) {
            return null;
        }
        double past = timeDist[0].getDepth();
        for (int counter = 1; counter < timeDist.length - 1; ++counter) {
            double current = timeDist[counter].getDepth();
            double next = timeDist[counter + 1].getDepth();
            if (this.interactionStyle.equals("TOPSIDE REFLECTION")) {
                // empty if block
            }
            if (this.interactionStyle.equals("TOPSIDE REFLECTION") && past < current && current > next) {
                return timeDist[counter];
            }
            if (this.interactionStyle.equals("BOTTOMSIDE REFLECTION") && past > current && current < next) {
                return timeDist[counter];
            }
            past = current;
        }
        return null;
    }

    public List<Arrival> getRequiredArrival(List<Arrival> arrivals) {
        ArrayList<Arrival> arrayList = new ArrayList<Arrival>();
        for (int counter = 0; counter < arrivals.size(); ++counter) {
            String arrivalName = arrivals.get(counter).getName();
            if (this.phaseName.startsWith("tt")) {
                if (this.phaseName.equals("tts") && arrivalName.toUpperCase().startsWith("S")) {
                    arrayList.add(arrivals.get(counter));
                    continue;
                }
                if (!this.phaseName.equals("ttp") || !arrivalName.toUpperCase().startsWith("P")) continue;
                arrayList.add(arrivals.get(counter));
                continue;
            }
            if (!this.phaseName.equals(arrivalName)) continue;
            arrayList.add(arrivals.get(counter));
        }
        return arrayList;
    }

    public double checkForLongway(double distance, double azimuth) {
        while (distance > 360.0) {
            distance -= 360.0;
        }
        if (distance > 180.0) {
            azimuth += 180.0;
        }
        return azimuth;
    }
}

