/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.eventStation;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.bag.TauPUtil;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.event.OriginImpl;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.eventStation.EventStationSubsetter;
import java.util.List;
import org.w3c.dom.Element;

public class PhaseExists
implements EventStationSubsetter {
    protected TauPUtil tauPTime;
    protected String modelName = "iasp91";
    protected String phaseName;

    public PhaseExists(Element config) throws ConfigurationException {
        Element element = SodUtil.getElement(config, "modelName");
        if (element != null) {
            this.modelName = SodUtil.getNestedText(element);
        }
        if ((element = SodUtil.getElement(config, "phaseName")) == null) {
            throw new ConfigurationException("Phase name not in configuration");
        }
        this.phaseName = SodUtil.getNestedText(element);
        try {
            this.tauPTime = TauPUtil.getTauPUtil(this.modelName);
        }
        catch (TauModelException e) {
            throw new ConfigurationException("Cannot initize TauP travel time calculator", e);
        }
    }

    @Override
    public StringTree accept(CacheEvent event, Station station, MeasurementStorage cookieJar) throws Exception {
        OriginImpl origin = event.get_preferred_origin();
        List<Arrival> arrivals = this.tauPTime.calcTravelTimes(station, origin, new String[]{this.phaseName});
        if (this.getRequiredArrival(arrivals) == null) {
            return new StringTreeLeaf(this, false);
        }
        return new StringTreeLeaf(this, true);
    }

    public Arrival getRequiredArrival(List<Arrival> arrivals) {
        Arrival requiredArrival = null;
        for (int counter = 0; counter < arrivals.size(); ++counter) {
            String arrivalName = arrivals.get(counter).getName();
            if (this.phaseName.startsWith("tt")) {
                if (this.phaseName.equals("tts") && arrivalName.toUpperCase().startsWith("S")) {
                    requiredArrival = arrivals.get(counter);
                    continue;
                }
                if (!this.phaseName.equals("ttp") || !arrivalName.toUpperCase().startsWith("P")) continue;
                requiredArrival = arrivals.get(counter);
                continue;
            }
            if (!this.phaseName.equals(arrivalName)) continue;
            requiredArrival = arrivals.get(counter);
        }
        return requiredArrival;
    }
}

