/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.eventStation;

import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.common.Area;
import edu.sc.seis.sod.model.common.Location;
import edu.sc.seis.sod.model.common.QuantityImpl;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.event.OriginImpl;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.AreaSubsetter;
import edu.sc.seis.sod.subsetter.eventStation.EventStationSubsetter;
import org.w3c.dom.Element;

public class MidPoint
extends AreaSubsetter
implements EventStationSubsetter {
    Area area;
    static final QuantityImpl ZERO = new QuantityImpl(0.0, UnitImpl.KILOMETER);

    public MidPoint(Element config) throws ConfigurationException {
        super(config);
    }

    @Override
    public StringTree accept(CacheEvent eventAccess, Station station, MeasurementStorage cookieJar) throws Exception {
        OriginImpl origin = eventAccess.get_preferred_origin();
        Location originLoc = origin.getLocation();
        Location loc = Location.of(station);
        double azimuth = SphericalCoords.azimuth((double)originLoc.latitude, (double)originLoc.longitude, (double)loc.latitude, (double)loc.longitude);
        double dist = SphericalCoords.distance((double)originLoc.latitude, (double)originLoc.longitude, (double)loc.latitude, (double)loc.longitude);
        double latitude = SphericalCoords.latFor((double)originLoc.latitude, (double)originLoc.longitude, (double)(dist /= 2.0), (double)azimuth);
        double longitude = SphericalCoords.lonFor((double)originLoc.latitude, (double)originLoc.longitude, (double)dist, (double)azimuth);
        return new StringTreeLeaf(this, this.accept(new Location((float)latitude, (float)longitude, ZERO, ZERO, originLoc.type)), "mid=(" + latitude + ", " + longitude + ")");
    }
}

