/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.eventStation;

import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.common.Location;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.event.OriginImpl;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.DistanceRangeSubsetter;
import edu.sc.seis.sod.subsetter.eventStation.EventStationSubsetter;
import edu.sc.seis.sod.subsetter.origin.MagnitudeRange;
import edu.sc.seis.sod.util.display.EventUtil;
import org.w3c.dom.Element;

public class LinearDistanceMagnitudeRange
extends DistanceRangeSubsetter
implements EventStationSubsetter {
    private MagnitudeRange magnitudeRange;

    public LinearDistanceMagnitudeRange(Element config) throws ConfigurationException {
        super(config);
        Element subElement = SodUtil.getElement(config, "magnitudeRange");
        this.magnitudeRange = (MagnitudeRange)SodUtil.load(subElement, "origin");
    }

    @Override
    public StringTree accept(CacheEvent eventAccess, Station station, MeasurementStorage cookieJar) {
        Location stationLoc = Location.of(station);
        return new StringTreeLeaf(this, this.accept(eventAccess, stationLoc.latitude, stationLoc.longitude));
    }

    public boolean accept(CacheEvent eventAccess, double stationLat, double stationLon) {
        OriginImpl origin = EventUtil.extractOrigin(eventAccess);
        Location originLoc = origin.getLocation();
        double actualDistance = SphericalCoords.distance((double)originLoc.latitude, (double)originLoc.longitude, (double)stationLat, (double)stationLon);
        if (actualDistance >= this.getMin().getValue() && actualDistance <= this.getMax().getValue()) {
            double resultantMagnitude = this.magnitudeRange.getMinValue() + (actualDistance - this.getMin().getValue()) * (this.magnitudeRange.getMaxValue() - this.magnitudeRange.getMinValue()) / (this.getMin().getValue() - this.getMax().getValue());
            for (int i = 0; i < origin.getMagnitudes().length; ++i) {
                if (!((double)origin.getMagnitudes()[i].value >= resultantMagnitude)) continue;
                if (this.magnitudeRange.getSearchTypes().length == 0) {
                    return true;
                }
                for (int j = 0; j < this.magnitudeRange.getSearchTypes().length; ++j) {
                    if (!origin.getMagnitudes()[i].type.equals(this.magnitudeRange.getSearchTypes())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

