/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.eventStation;

import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.common.QuantityImpl;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.event.OriginImpl;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.DistanceRangeSubsetter;
import edu.sc.seis.sod.subsetter.eventStation.EventStationSubsetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class DistanceRange
extends DistanceRangeSubsetter
implements EventStationSubsetter {
    private static final Logger logger = LoggerFactory.getLogger(DistanceRange.class);

    public DistanceRange(Element config) throws ConfigurationException {
        super(config);
    }

    @Override
    public StringTree accept(CacheEvent eventAccess, Station station, MeasurementStorage cookieJar) throws Exception {
        OriginImpl origin = eventAccess.getOrigin();
        double actualDistance = SphericalCoords.distance((double)origin.getLocation().latitude, (double)origin.getLocation().longitude, (double)station.getLatitude().getValue(), (double)station.getLongitude().getValue());
        QuantityImpl dist = new QuantityImpl(actualDistance, UnitImpl.DEGREE);
        if (dist.greaterThanEqual(this.getMin()) && dist.lessThanEqual(this.getMax())) {
            return new StringTreeLeaf(this, true, "DistanceRange(" + String.valueOf(this.getMin()) + ", " + String.valueOf(this.getMax()) + ")");
        }
        return new StringTreeLeaf(this, false, "DistanceRange(" + String.valueOf(this.getMin()) + ", " + String.valueOf(this.getMax()) + ")" + dist.toString());
    }
}

