/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.eventChannel.vector;

import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.station.ChannelGroup;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.subsetter.LogicalSubsetter;
import edu.sc.seis.sod.subsetter.Subsetter;
import edu.sc.seis.sod.subsetter.channel.ChannelSubsetter;
import edu.sc.seis.sod.subsetter.eventChannel.EventChannelLogicalSubsetter;
import edu.sc.seis.sod.subsetter.eventChannel.EventChannelSubsetter;
import edu.sc.seis.sod.subsetter.eventChannel.vector.ANDEventChannelWrapper;
import edu.sc.seis.sod.subsetter.eventChannel.vector.EventVectorSubsetter;
import edu.sc.seis.sod.subsetter.eventStation.EventStationLogicalSubsetter;
import edu.sc.seis.sod.subsetter.eventStation.EventStationSubsetter;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;

public class EventVectorLogicalSubsetter
extends LogicalSubsetter {
    public static final List<String> packages = new LinkedList<String>();

    public EventVectorLogicalSubsetter(Element config) throws ConfigurationException {
        super(config);
    }

    @Override
    public List<String> getPackages() {
        return packages;
    }

    @Override
    protected Subsetter getSubsetter(Subsetter s) throws ConfigurationException {
        return EventVectorLogicalSubsetter.createSubsetter(s);
    }

    public static EventVectorSubsetter createSubsetter(final Subsetter s) throws ConfigurationException {
        if (s instanceof EventVectorSubsetter) {
            return (EventVectorSubsetter)s;
        }
        if (s instanceof EventChannelSubsetter || s instanceof ChannelSubsetter) {
            return new ANDEventChannelWrapper(EventChannelLogicalSubsetter.createSubsetter(s));
        }
        return new EventVectorSubsetter(){
            EventStationSubsetter ecs;
            {
                this.ecs = EventStationLogicalSubsetter.createSubsetter(s);
            }

            @Override
            public StringTree accept(CacheEvent event, ChannelGroup channelGroup, MeasurementStorage cookieJar) throws Exception {
                return this.ecs.accept(event, channelGroup.getStation(), cookieJar);
            }
        };
    }

    static {
        packages.add("eventChannel.vector");
        packages.add("eventChannel");
        packages.addAll(EventStationLogicalSubsetter.packages);
    }
}

