/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.eventChannel;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.subsetter.LogicalSubsetter;
import edu.sc.seis.sod.subsetter.Subsetter;
import edu.sc.seis.sod.subsetter.channel.ChannelLogicalSubsetter;
import edu.sc.seis.sod.subsetter.channel.ChannelSubsetter;
import edu.sc.seis.sod.subsetter.eventChannel.EventChannelSubsetter;
import edu.sc.seis.sod.subsetter.eventStation.EventStationLogicalSubsetter;
import edu.sc.seis.sod.subsetter.eventStation.EventStationSubsetter;
import edu.sc.seis.sod.subsetter.origin.EventLogicalSubsetter;
import edu.sc.seis.sod.subsetter.origin.OriginSubsetter;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;

public class EventChannelLogicalSubsetter
extends LogicalSubsetter {
    public static final List<String> packages = new LinkedList<String>();

    public EventChannelLogicalSubsetter(Element config) throws ConfigurationException {
        super(config);
    }

    protected EventChannelLogicalSubsetter() {
    }

    @Override
    public List<String> getPackages() {
        return packages;
    }

    @Override
    protected Subsetter getSubsetter(Subsetter s) throws ConfigurationException {
        return EventChannelLogicalSubsetter.createSubsetter(s);
    }

    public static EventChannelSubsetter createSubsetter(final Subsetter s) throws ConfigurationException {
        if (s instanceof EventChannelSubsetter) {
            return (EventChannelSubsetter)s;
        }
        if (s instanceof EventStationSubsetter || s instanceof OriginSubsetter) {
            return new EventChannelSubsetter(){
                EventStationSubsetter ecs;
                {
                    this.ecs = EventStationLogicalSubsetter.createSubsetter(s);
                }

                @Override
                public StringTree accept(CacheEvent event, Channel channel, MeasurementStorage cookieJar) throws Exception {
                    return this.ecs.accept(event, channel.getStation(), cookieJar);
                }
            };
        }
        return new EventChannelSubsetter(){
            ChannelSubsetter ecs;
            {
                this.ecs = ChannelLogicalSubsetter.createSubsetter(s);
            }

            @Override
            public StringTree accept(CacheEvent event, Channel channel, MeasurementStorage cookieJar) throws Exception {
                return this.ecs.accept(channel, Start.getNetworkArm().getNetworkSource());
            }
        };
    }

    static {
        packages.add("eventChannel");
        packages.add("eventStation");
        packages.addAll(ChannelLogicalSubsetter.packages);
        packages.addAll(EventLogicalSubsetter.packages);
    }
}

