/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.eventChannel;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.DOMHelper;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.bag.BestChannelUtil;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.station.ChannelGroup;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import edu.sc.seis.sod.status.Fail;
import edu.sc.seis.sod.status.Pass;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.subsetter.eventChannel.EventChannelSubsetter;
import edu.sc.seis.sod.subsetter.eventChannel.vector.EventVectorSubsetter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class BestChannelAtStation
implements EventChannelSubsetter,
EventVectorSubsetter {
    BestChannelUtil bestChanUtil = new BestChannelUtil();

    public BestChannelAtStation(Element config) {
        if (DOMHelper.hasElement(config, "siteCodeHeuristic")) {
            String siteCodeHeuristic = SodUtil.getNestedText(SodUtil.getElement(config, "siteCodeHeuristic"));
            this.bestChanUtil.setSiteCodeHeuristic(siteCodeHeuristic.split(","));
        }
        if (DOMHelper.hasElement(config, "gainCodeHeuristic")) {
            String gainCodeHeuristic = SodUtil.getNestedText(SodUtil.getElement(config, "gainCodeHeuristic"));
            this.bestChanUtil.setGainCodeHeuristic(gainCodeHeuristic.split(","));
        }
        if (DOMHelper.hasElement(config, "bandCodeHeuristic")) {
            String bandCodeHeuristic = SodUtil.getNestedText(SodUtil.getElement(config, "bandCodeHeuristic"));
            this.bestChanUtil.setBandCodeHeuristic(bandCodeHeuristic.split(","));
        }
        if (DOMHelper.hasElement(config, "orientationCodeHeuristic")) {
            String orientationCodeHeuristic = SodUtil.getNestedText(SodUtil.getElement(config, "orientationCodeHeuristic"));
            this.bestChanUtil.setOrientationCodeHeuristic(orientationCodeHeuristic.split(","));
        }
    }

    @Override
    public StringTree accept(CacheEvent event, Channel channel, MeasurementStorage cookieJar) throws Exception {
        Channel bestChan;
        List<Channel> staChans = Start.getNetworkArm().getSuccessfulChannels(channel.getStation());
        List<Channel> allChannels = BestChannelUtil.pruneChannels(staChans, event.getOrigin().getOriginTime());
        Channel[] bestChannels = this.bestChanUtil.getBestMotionVector(allChannels);
        if (bestChannels == null && (bestChan = this.bestChanUtil.getBestChannel(allChannels)) != null) {
            bestChannels = new Channel[]{bestChan};
        }
        if (bestChannels == null) {
            return new Fail((Object)this, "No best channels");
        }
        for (int i = 0; i < bestChannels.length; ++i) {
            if (!ChannelIdUtil.areEqual(channel, bestChannels[i])) continue;
            return new Pass(this);
        }
        return new Fail(this);
    }

    @Override
    public StringTree accept(CacheEvent event, ChannelGroup channelGroup, MeasurementStorage cookieJar) throws Exception {
        List<ChannelGroup> staChans = Start.getNetworkArm().getSuccessfulChannelGroups(channelGroup.getStation());
        List<Channel> allChannels = new ArrayList<Channel>(staChans.size() * 3);
        for (ChannelGroup cg : staChans) {
            Channel[] cgChans = cg.getChannels();
            allChannels.add(cgChans[0]);
            allChannels.add(cgChans[1]);
            allChannels.add(cgChans[2]);
        }
        Channel[] bestChannels = this.bestChanUtil.getBestMotionVector(allChannels = BestChannelUtil.pruneChannels(allChannels, event.getOrigin().getOriginTime()));
        if (bestChannels == null) {
            return new Fail((Object)this, "No best channel group");
        }
        ChannelGroup best = new ChannelGroup(bestChannels);
        if (best.areEqual(channelGroup)) {
            return new Pass(this);
        }
        return new Fail(this);
    }
}

