/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.channel;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.model.common.SamplingImpl;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.RangeSubsetter;
import edu.sc.seis.sod.subsetter.channel.ChannelSubsetter;
import java.time.Duration;
import org.w3c.dom.Element;

public class Sampling
extends RangeSubsetter
implements ChannelSubsetter {
    public Sampling(Element config) throws ConfigurationException {
        super(config, 0.0, 2.147483647E9);
        Duration interval = SodUtil.loadTimeInterval(SodUtil.getElement(config, "interval"));
        this.min = this.getHertz((int)this.getMinValue(), interval);
        this.max = this.getHertz((int)this.getMaxValue(), interval);
    }

    @Override
    public StringTree accept(Channel channel, NetworkSource network) throws Exception {
        return new StringTreeLeaf(this, this.accept(channel.getSampleRate().getValue()));
    }

    public boolean accept(SamplingImpl channelSampling) {
        return this.accept(this.getHertz(channelSampling));
    }

    double getHertz(int val, Duration interval) {
        return this.getHertz(new SamplingImpl(val, interval));
    }

    double getHertz(SamplingImpl sampling) {
        return sampling.getFrequency().getValue(UnitImpl.HERTZ);
    }
}

