/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.channel;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.InvalidResponse;
import edu.sc.seis.seisFile.fdsnws.stationxml.PolesZeros;
import edu.sc.seis.seisFile.fdsnws.stationxml.Response;
import edu.sc.seis.seisFile.fdsnws.stationxml.ResponseStage;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.hibernate.ChannelNotFound;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.status.Fail;
import edu.sc.seis.sod.status.Pass;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.subsetter.VelocityFileElementParser;
import edu.sc.seis.sod.subsetter.channel.ChannelSubsetter;
import edu.sc.seis.sod.util.convert.sac.StationXMLToSacPoleZero;
import edu.sc.seis.sod.util.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.sod.velocity.PrintlineVelocitizer;
import java.io.FileNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SacPoleZeroWriter
implements ChannelSubsetter {
    public static final String DEFAULT_DIRECTORY = "polezero/";
    public static final String DEFAULT_TEMPLATE = "${channel.codes}.${channel.getStart('yyyy_DDD_HH_mm_ss')}.sacpz";
    private String template;
    private PrintlineVelocitizer velocitizer;
    private static final Logger logger = LoggerFactory.getLogger(SacPoleZeroWriter.class);

    public SacPoleZeroWriter(Element config) throws ConfigurationException {
        VelocityFileElementParser parser = new VelocityFileElementParser(config, DEFAULT_DIRECTORY, DEFAULT_TEMPLATE);
        this.template = parser.getTemplate();
        this.velocitizer = new PrintlineVelocitizer(new String[]{this.template});
    }

    @Override
    public StringTree accept(Channel chan, NetworkSource network) throws Exception {
        Response response;
        try {
            response = network.getResponse(chan);
        }
        catch (ChannelNotFound e) {
            return new Fail((Object)this, "No instrumentation");
        }
        catch (InvalidResponse e) {
            logger.warn("Invalid instrumentation: ", (Throwable)e);
            return new Fail((Object)this, "Invalid instrumentation: " + e.getMessage());
        }
        ResponseStage first = response.getFirstStage();
        if (!(first.getResponseItem() instanceof PolesZeros)) {
            return new Fail((Object)this, "first (sensor) stage is not a PoleZero: " + first.getResponseItem().getClass().getSimpleName());
        }
        String responseOut = StationXMLToSacPoleZero.convert(response).toString();
        try {
            this.velocitizer.evaluate(this.template, responseOut, chan);
        }
        catch (FileNotFoundException fe) {
            GlobalExceptionHandler.handle("Error while writing response file for " + ChannelIdUtil.toString(chan), fe);
            return new Fail((Object)this, "Error while writing response file", fe);
        }
        return new Pass(this);
    }
}

