/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.channel;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.InstrumentSensitivity;
import edu.sc.seis.seisFile.fdsnws.stationxml.InvalidResponse;
import edu.sc.seis.seisFile.fdsnws.stationxml.Response;
import edu.sc.seis.sod.hibernate.ChannelNotFound;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.status.Fail;
import edu.sc.seis.sod.status.Pass;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.channel.ChannelSubsetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepairSensitivity
implements ChannelSubsetter {
    private Logger logger = LoggerFactory.getLogger(RepairSensitivity.class);

    @Override
    public StringTree accept(Channel channel, NetworkSource network) throws Exception {
        try {
            InstrumentSensitivity sensitivity;
            InstrumentSensitivity instrumentSensitivity = sensitivity = channel.getResponse() == null ? null : channel.getResponse().getInstrumentSensitivity();
            if (sensitivity != null && sensitivity.getSensitivityValue() != -1.0f) {
                return new Pass(this);
            }
            Response response = network.getResponse(channel);
            if (Response.isValid((Response)response)) {
                return new Pass(this);
            }
            if (response.getResponseStageList().size() == 0) {
                return new StringTreeLeaf(this, false, "No stages in the response of " + ChannelIdUtil.toString(channel));
            }
            Response.repairResponse((Response)response);
            return new StringTreeLeaf(this, Response.isValid((Response)response));
        }
        catch (ChannelNotFound e) {
            return new Fail((Object)this, "No instrumentation");
        }
        catch (InvalidResponse e) {
            return new Fail((Object)this, "Invalid instrumentation: " + e.getMessage());
        }
    }
}

