/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.channel;

import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.DOMHelper;
import edu.sc.seis.sod.model.common.Orientation;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.channel.ChannelSubsetter;
import org.w3c.dom.Element;

public class OrientationRange
implements ChannelSubsetter {
    private float azimuth;
    private float dip;
    private float offset;

    public OrientationRange(Element config) {
        this.azimuth = Float.parseFloat(DOMHelper.extractText(config, "azimuth"));
        this.dip = Float.parseFloat(DOMHelper.extractText(config, "dip"));
        this.offset = Float.parseFloat(DOMHelper.extractText(config, "maxOffset"));
    }

    @Override
    public StringTree accept(Channel c, NetworkSource network) throws Exception {
        Orientation ori = Orientation.of(c);
        double actualDistance = SphericalCoords.distance((double)ori.dip, (double)ori.azimuth, (double)this.dip, (double)this.azimuth);
        return new StringTreeLeaf(this, actualDistance <= (double)this.offset);
    }
}

