/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.channel;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.source.seismogram.ConstantSeismogramSourceLocator;
import edu.sc.seis.sod.source.seismogram.FdsnDataSelect;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.channel.ChannelEffectiveTimeOverlap;
import edu.sc.seis.sod.subsetter.channel.ChannelSubsetter;
import edu.sc.seis.sod.subsetter.channel.RecentRequest;
import edu.sc.seis.sod.util.time.ClockUtil;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class HadDataLastWeek
implements ChannelSubsetter {
    private HashMap<String, RecentRequest> recentRequests = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(HadDataLastWeek.class);
    protected ConstantSeismogramSourceLocator dcLocator = new FdsnDataSelect();
    private static final Duration REQ_INTERVAL = Duration.ofMinutes(10L);
    private Duration MAX_CACHE = Duration.ofDays(1L);

    public HadDataLastWeek(Element el) throws Exception {
        Object sodObject = SodUtil.load(el, new String[]{"seismogram"});
        if (!(sodObject instanceof ConstantSeismogramSourceLocator)) {
            throw new ConfigurationException("Wrapped SeismogramSource must be instance of ConstantSeismogramSourceLocator");
        }
        this.dcLocator = (ConstantSeismogramSourceLocator)sodObject;
    }

    @Override
    public StringTree accept(Channel channel, NetworkSource network) throws Exception {
        Instant now = ClockUtil.now();
        ChannelEffectiveTimeOverlap overlap = new ChannelEffectiveTimeOverlap(now.minus(this.makeDayInterval(7)), now);
        if (!overlap.accept(channel, network).isSuccess()) {
            return new StringTreeLeaf(this, false, "Channel Ended");
        }
        String key = ChannelIdUtil.toStringNoDates(channel);
        if (this.recentRequests.containsKey(key)) {
            RecentRequest r = this.recentRequests.get(key);
            if (r.when.plus(this.MAX_CACHE).isAfter(ClockUtil.now())) {
                return new StringTreeLeaf(this, r.hadData);
            }
            this.recentRequests.remove(r);
        }
        ArrayList<RequestFilter> reqs = new ArrayList<RequestFilter>();
        for (int i = 0; i < 7; ++i) {
            reqs.add(new RequestFilter(channel, now.minus(this.makeDayInterval(i)).minus(REQ_INTERVAL), now.minus(this.makeDayInterval(i))));
        }
        if (this.dcLocator.getSeismogramSource().retrieveData(reqs).size() > 0) {
            logger.debug(ChannelIdUtil.toStringNoDates(channel) + " had data");
            this.recentRequests.put(key, new RecentRequest(channel, ClockUtil.now(), true));
            return new StringTreeLeaf(this, true);
        }
        logger.debug(ChannelIdUtil.toStringNoDates(channel) + " didn't have data");
        this.recentRequests.put(key, new RecentRequest(channel, ClockUtil.now(), false));
        return new StringTreeLeaf(this, false);
    }

    private Duration makeDayInterval(int days) {
        return Duration.ofDays(days);
    }
}

