/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.channel;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.UserConfigurationException;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.channel.ChannelSubsetter;
import org.w3c.dom.Element;

public class ChannelCode
implements ChannelSubsetter {
    String required;
    private String code;
    private String acceptedCode;

    public ChannelCode(Element config) throws UserConfigurationException {
        this(SodUtil.getNestedText(config));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ChannelCode(String string) throws UserConfigurationException {
        this.code = string;
        this.acceptedCode = string.toUpperCase();
        if (this.acceptedCode.length() == 0 || this.acceptedCode.length() == 1 && this.acceptedCode.charAt(0) == '*') {
            this.required = "***";
        } else if (this.acceptedCode.length() == 2) {
            if (this.acceptedCode.charAt(0) == '*') {
                this.required = "**" + this.acceptedCode.charAt(1);
            } else {
                if (this.acceptedCode.charAt(1) != '*') throw new UserConfigurationException("A channelCode must be of length 3 if it doesn't contain any '*' characters.  Yours was '" + string + "'");
                this.required = this.acceptedCode.charAt(0) + "**";
            }
        } else {
            if (this.acceptedCode.length() != 3) throw new UserConfigurationException("A channelCode can be at most of length 3.  Yours was '" + string + "'");
            this.required = this.acceptedCode;
        }
        this.required = this.required.replace('?', '*');
    }

    @Override
    public StringTree accept(Channel channel, NetworkSource network) {
        String code = channel.getChannelCode();
        for (int i = 0; i < this.required.length(); ++i) {
            if (this.required.charAt(i) == '*' || code.charAt(i) == this.required.charAt(i)) continue;
            return new StringTreeLeaf(this, false);
        }
        return new StringTreeLeaf(this, true);
    }

    public String getCode() {
        return this.code;
    }
}

