/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.channel;

import edu.sc.seis.seisFile.fdsnws.stationxml.ResponseStage;
import edu.sc.seis.seisFile.fdsnws.stationxml.Unit;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.common.UnknownUnit;
import edu.sc.seis.sod.status.Fail;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.channel.AbstractStageSubsetter;
import edu.sc.seis.sod.util.convert.stationxml.StationXMLToFissures;
import org.w3c.dom.Element;

public abstract class AbstractStageUnit
extends AbstractStageSubsetter {
    UnitImpl unit;

    public AbstractStageUnit(Element config) throws ConfigurationException {
        super(config);
        this.unit = SodUtil.loadUnit(SodUtil.getElement(config, "unit"));
    }

    @Override
    protected abstract StringTree accept(ResponseStage var1);

    protected StringTree accept(Unit stageUnit) {
        try {
            return this.accept(StationXMLToFissures.convertUnit(stageUnit));
        }
        catch (UnknownUnit e) {
            return new Fail((Object)this, "Unable to convert unit: ", e);
        }
    }

    protected StringTree accept(UnitImpl stageUnit) {
        return new StringTreeLeaf(this, this.unit.isConvertableTo(UnitImpl.createUnitImpl(stageUnit)) && this.unit.toString().equalsIgnoreCase(stageUnit.toString()));
    }
}

