/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.availableData;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.DOMHelper;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.common.TimeRange;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.availableData.AvailableDataSubsetter;
import edu.sc.seis.sod.util.time.CoverageTool;
import edu.sc.seis.sod.util.time.ReduceTool;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class PercentCoverage
implements AvailableDataSubsetter {
    private double percentage;

    public PercentCoverage(Element content) {
        DOMHelper.extractDouble(content, ".", 100.0);
    }

    public PercentCoverage(double percentage) {
        this.percentage = percentage;
    }

    @Override
    public StringTree accept(CacheEvent event, Channel channel, RequestFilter[] request, RequestFilter[] available, MeasurementStorage cookieJar) {
        return new StringTreeLeaf(this, this.accept(request, available));
    }

    public boolean accept(RequestFilter[] original, RequestFilter[] available) {
        return this.percentCovered(original, available) >= this.percentage;
    }

    public double percentCovered(RequestFilter[] request, RequestFilter[] available) {
        RequestFilter[] uncovered = CoverageTool.notCovered(request, available);
        Duration totalOriginalTime = this.sum(this.toMSTR(request));
        Duration totalUncoveredTime = this.sum(this.toMSTR(uncovered));
        return (1.0 - TimeUtils.durationToDoubleSeconds((Duration)totalUncoveredTime) / TimeUtils.durationToDoubleSeconds((Duration)totalOriginalTime)) * 100.0;
    }

    private Duration sum(List microSecondTimeRanges) {
        Duration total = Duration.ofNanos(0L);
        for (TimeRange time : microSecondTimeRanges) {
            total = total.plus(time.getInterval());
        }
        return total;
    }

    private List<TimeRange> toMSTR(RequestFilter[] filters) {
        filters = ReduceTool.merge(filters);
        ArrayList<TimeRange> mstrs = new ArrayList<TimeRange>(filters.length);
        for (int i = 0; i < filters.length; ++i) {
            mstrs.add(new TimeRange(filters[i]));
        }
        return mstrs;
    }
}

