/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.availableData;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.SodElement;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.availableData.AvailableDataSubsetter;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class NoGaps
implements AvailableDataSubsetter,
SodElement {
    private static Logger logger = LoggerFactory.getLogger(NoGaps.class);

    public NoGaps(Element config) {
    }

    @Override
    public StringTree accept(CacheEvent event, Channel channel, RequestFilter[] request, RequestFilter[] available, MeasurementStorage cookieJar) {
        boolean ok = true;
        logger.debug("original length=" + request.length + "  available legnth=" + available.length);
        for (int counter = 0; counter < request.length; ++counter) {
            ok = false;
            Instant originalStartDate = request[counter].startTime;
            Instant originalEndDate = request[counter].endTime;
            for (int subcounter = 0; subcounter < available.length; ++subcounter) {
                Instant availableStartDate = available[subcounter].startTime;
                Instant availableEndDate = available[subcounter].endTime;
                logger.debug(String.valueOf(originalStartDate) + " " + String.valueOf(originalEndDate) + " - " + String.valueOf(availableStartDate) + " " + String.valueOf(availableEndDate));
                if (!originalStartDate.isAfter(availableStartDate) && !originalStartDate.equals(availableStartDate) || !originalEndDate.isBefore(availableEndDate) && !originalEndDate.equals(availableEndDate)) continue;
                ok = true;
                break;
            }
            if (ok) continue;
            logger.debug("NoGaps fail");
            return new StringTreeLeaf(this, false);
        }
        return new StringTreeLeaf(this, true);
    }
}

