/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.availableData;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.SodElement;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.model.seismogram.RequestFilterUtil;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.availableData.AvailableDataSubsetter;
import edu.sc.seis.sod.subsetter.availableData.PercentCoverage;
import edu.sc.seis.sod.util.time.CoverageTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullCoverage
implements AvailableDataSubsetter,
SodElement {
    private PercentCoverage pc = new PercentCoverage(100.0);
    private static Logger logger = LoggerFactory.getLogger((String)FullCoverage.class.getName());

    @Override
    public StringTree accept(CacheEvent event, Channel channel, RequestFilter[] request, RequestFilter[] available, MeasurementStorage cookieJar) {
        double coveragePercentage = this.pc.percentCovered(request, available);
        if (available.length == 0) {
            return new StringTreeLeaf(this, false, "No available data");
        }
        RequestFilter[] notCovered = CoverageTool.notCovered(request, available);
        float minSps = ChannelIdUtil.minSPSForBandCode(channel.getChannelCode());
        if (minSps > 0.0f) {
            notCovered = RequestFilterUtil.removeSmallRequests(notCovered, TimeUtils.durationFromSeconds((double)(1.0f / minSps)));
        }
        if (notCovered.length == 0) {
            String reason = "Data returned completly covers the request";
            return new StringTreeLeaf(this, true, reason);
        }
        String reason = "Data does not cover " + notCovered.length + " sections of the request. ";
        for (int i = 0; i < notCovered.length; ++i) {
            reason = reason + notCovered[i].startTime.toString() + " to " + notCovered[i].endTime.toString() + ",  ";
        }
        return new StringTreeLeaf(this, coveragePercentage > 99.0, reason + coveragePercentage + " percent of data covered");
    }
}

