/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter;

import edu.sc.seis.sod.SodUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RangeSubsetter {
    boolean allowEqualsToMin = true;
    boolean allowEqualsToMax = true;
    public static final double DEFAULT_MIN = -1.7976931348623157E308;
    public static final double DEFAULT_MAX = Double.MAX_VALUE;
    protected double min = -1.7976931348623157E308;
    protected double max = Double.MAX_VALUE;

    public RangeSubsetter() {
    }

    public RangeSubsetter(Element config) {
        this.parseConfig(config);
    }

    public RangeSubsetter(Element config, double defaultMin, double defaultMax) {
        this.min = defaultMin;
        this.max = defaultMax;
        this.parseConfig(config);
    }

    protected void parseConfig(Element config) {
        NodeList children = config.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            Element el = (Element)children.item(i);
            String tagName = el.getTagName();
            if (tagName.equals("min") || tagName.equals("greaterThanEquals")) {
                this.min = RangeSubsetter.extractValue(el);
                continue;
            }
            if (tagName.equals("max") || tagName.equals("lessThanEquals")) {
                this.max = RangeSubsetter.extractValue(el);
                continue;
            }
            if (tagName.equals("greaterThan")) {
                this.min = RangeSubsetter.extractValue(el);
                this.allowEqualsToMin = false;
                continue;
            }
            if (!tagName.equals("lessThan")) continue;
            this.max = RangeSubsetter.extractValue(el);
            this.allowEqualsToMax = false;
        }
    }

    public boolean accept(double value) {
        return this.acceptMin(value) && this.acceptMax(value);
    }

    public boolean acceptMin(double value) {
        return this.min < value || this.allowEqualsToMin && this.min == value;
    }

    public boolean acceptMax(double value) {
        return this.max > value || this.allowEqualsToMax && this.max == value;
    }

    public String toString() {
        Object out = "(";
        out = (String)out + (String)(this.min == -1.7976931348623157E308 ? "-inf" : "" + this.min);
        out = (String)out + ", ";
        out = (String)out + (String)(this.max == Double.MAX_VALUE ? "inf" : "" + this.max);
        out = (String)out + ")";
        return out;
    }

    private static double extractValue(Element e) {
        return Double.parseDouble(SodUtil.getNestedText(e));
    }

    public double getMinValue() {
        return this.min;
    }

    public double getMaxValue() {
        return this.max;
    }
}

