/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter;

import edu.sc.seis.seisFile.fdsnws.stationxml.BaseNodeType;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.model.common.TimeRange;
import edu.sc.seis.sod.model.event.NoPreferredOrigin;
import edu.sc.seis.sod.model.event.StatefulEvent;
import edu.sc.seis.sod.subsetter.EffectiveTimeOverlap;
import java.time.Duration;
import java.time.Instant;

public class EventEffectiveTimeOverlap
extends EffectiveTimeOverlap {
    static final Duration DEFAULT_OFFSET = Duration.ofDays(3L);

    public EventEffectiveTimeOverlap(StatefulEvent event) throws NoPreferredOrigin {
        super(EventEffectiveTimeOverlap.createTimeRange(event));
    }

    static TimeRange createTimeRange(StatefulEvent event) throws NoPreferredOrigin {
        Instant originTime = event.getOrigin().getOriginTime();
        if (originTime == null) {
            throw new RuntimeException("origin time is null");
        }
        return new TimeRange(originTime, originTime.plus(DEFAULT_OFFSET));
    }

    public boolean overlaps(Network net) {
        return this.overlaps(new TimeRange((BaseNodeType)net));
    }

    public boolean overlaps(Station station) {
        return this.overlaps(new TimeRange((BaseNodeType)station));
    }

    public boolean overlaps(Channel channel) {
        return this.overlaps(new TimeRange((BaseNodeType)channel));
    }
}

