/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.model.common.TimeRange;
import edu.sc.seis.sod.source.event.MicroSecondTimeRangeSupplier;
import edu.sc.seis.sod.subsetter.Subsetter;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public abstract class EffectiveTimeOverlap
implements Subsetter {
    private MicroSecondTimeRangeSupplier timeRange;
    private static Logger logger = LoggerFactory.getLogger(EffectiveTimeOverlap.class);

    public EffectiveTimeOverlap(MicroSecondTimeRangeSupplier timeRange) {
        this.timeRange = timeRange;
    }

    public EffectiveTimeOverlap(TimeRange range) {
        this(range.getBeginTime(), range.getEndTime());
    }

    public EffectiveTimeOverlap(final Instant start, final Instant end) {
        this.timeRange = new MicroSecondTimeRangeSupplier(){
            TimeRange range;
            {
                this.range = new TimeRange(start, end);
            }

            @Override
            public TimeRange getMSTR() {
                return this.range;
            }
        };
    }

    public EffectiveTimeOverlap(Element config) throws ConfigurationException {
        this.timeRange = SodUtil.loadTimeRange(config);
    }

    public boolean overlaps(TimeRange otherRange) {
        Instant otherStart = otherRange.getBeginTime();
        Instant otherEnd = otherRange.getEndTime() == null ? TimeUtils.future : otherRange.getEndTime();
        return this.overlaps(otherStart, otherEnd);
    }

    public boolean overlaps(Instant otherStart, Instant otherEnd) {
        TimeRange mstr = this.timeRange.getMSTR();
        Instant start = mstr.getBeginTime();
        Instant end = mstr.getEndTime();
        if (end == null && start == null) {
            return true;
        }
        if (end == null && start.isBefore(otherEnd)) {
            return true;
        }
        if (start == null && end.isAfter(otherStart)) {
            return true;
        }
        return !otherStart.isAfter(end) && !otherEnd.isBefore(start);
    }
}

